/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.microsoft.semantickernel.SKException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemoryException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public MemoryException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public MemoryException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public MemoryException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(MemoryException.getDefaultMessage(errorCode, message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    private static String getDefaultMessage(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        return String.format("%s: %s", errorCode.getMessage(), message);
    }

    public static enum ErrorCodes {
        UNKNOWN("Unknown error"),
        FAILED_TO_CREATE_COLLECTION("Failed to create collection"),
        FAILED_TO_DELETE_COLLECTION("Failed to delete collection"),
        UNABLE_TO_DESERIALIZE_METADATA("Unable to deserialize metadata"),
        ATTEMPTED_TO_ACCESS_NONEXISTENT_COLLECTION("Attempted to access non-existent collection");

        private final String message;

        public String getMessage() {
            return this.message;
        }

        private ErrorCodes(String message) {
            this.message = message;
        }
    }
}

