/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.ai.embeddings.Embedding;
import com.microsoft.semantickernel.memory.DataEntryBase;
import com.microsoft.semantickernel.memory.MemoryException;
import com.microsoft.semantickernel.memory.MemoryRecordMetadata;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemoryRecord
extends DataEntryBase {
    @Nonnull
    private final Embedding embedding;
    @Nonnull
    private final MemoryRecordMetadata metadata;

    @JsonCreator
    public MemoryRecord(@JsonProperty(value="additional_metadata") @Nonnull MemoryRecordMetadata metadata, @JsonProperty(value="embedding") @Nonnull Embedding embedding, @JsonProperty(value="key") @Nullable String key, @JsonProperty(value="timestamp") @Nullable ZonedDateTime timestamp) {
        super(key, timestamp);
        this.metadata = metadata;
        this.embedding = embedding;
    }

    public Embedding getEmbedding() {
        return this.embedding;
    }

    public MemoryRecordMetadata getMetadata() {
        return this.metadata;
    }

    public static MemoryRecord referenceRecord(@Nonnull String externalId, @Nonnull String sourceName, @Nullable String description, @Nonnull Embedding embedding, @Nullable String additionalMetadata, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        MemoryRecordMetadata metadata = new MemoryRecordMetadata(true, externalId, "", description != null ? description : "", sourceName, additionalMetadata != null ? additionalMetadata : "");
        return new MemoryRecord(metadata, embedding, key, timestamp);
    }

    public static MemoryRecord localRecord(@Nonnull String id, @Nonnull String text, @Nullable String description, @Nonnull Embedding embedding, @Nullable String additionalMetadata, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        boolean isReference = false;
        String emptyString = "";
        MemoryRecordMetadata metadata = new MemoryRecordMetadata(isReference, id, text, description != null ? description : emptyString, emptyString, additionalMetadata != null ? additionalMetadata : emptyString);
        return new MemoryRecord(metadata, embedding, key, timestamp);
    }

    public static MemoryRecord fromMetadata(@Nonnull MemoryRecordMetadata metadata, @Nullable Embedding embedding, @Nullable String key, @Nullable ZonedDateTime timestamp) {
        return new MemoryRecord(metadata, embedding != null ? embedding : Embedding.empty(), key, timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemoryRecord)) {
            return false;
        }
        MemoryRecord that = (MemoryRecord)o;
        if (!this.embedding.equals(that.embedding)) {
            return false;
        }
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        int result = this.embedding.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "MemoryRecord{embedding=" + this.embedding + ", metadata=" + this.metadata + '}';
    }

    public String getSerializedMetadata() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString((Object)this.metadata);
    }

    public String getSerializedEmbedding() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString((Object)this.embedding);
    }

    public static MemoryRecord fromJsonMetadata(String json, @Nullable Embedding embedding, @Nullable String key, @Nullable ZonedDateTime timestamp) throws JsonProcessingException {
        MemoryRecordMetadata metadata = (MemoryRecordMetadata)new ObjectMapper().readValue(json, MemoryRecordMetadata.class);
        if (metadata != null) {
            return new MemoryRecord(metadata, embedding != null ? embedding : Embedding.empty(), key, timestamp);
        }
        throw new MemoryException(MemoryException.ErrorCodes.UNABLE_TO_DESERIALIZE_METADATA, "Unable to create memory record from serialized metadata");
    }
}

