/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner;

import com.microsoft.semantickernel.SKException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlanningException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public PlanningException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public PlanningException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public PlanningException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(PlanningException.getDefaultMessage(errorCode, message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    private static String getDefaultMessage(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        return String.format("%s: %s", errorCode.getMessage(), message);
    }

    public static enum ErrorCodes {
        UnknownError("Unknown error"),
        InvalidGoal("Invalid goal"),
        InvalidPlan("Invalid plan"),
        InvalidConfiguration("Invalid configuration"),
        PlanExecutionProducedNoResults("Plan execution produced no result values");

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

