/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner;

import com.microsoft.semantickernel.SKException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlanningException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public PlanningException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public PlanningException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public PlanningException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(PlanningException.formatDefaultMessage(errorCode.getMessage(), message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCodes {
        UNKNOWN_ERROR("Unknown error"),
        INVALID_GOAL("Invalid goal"),
        INVALID_PLAN("Invalid plan"),
        INVALID_CONFIGURATION("Invalid configuration"),
        PLAN_EXECUTION_PRODUCED_NO_RESULTS("Plan execution produced no result values");

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

