/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.contextvariables.converters;

import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class DateTimeContextVariableTypeConverter
extends ContextVariableTypeConverter<OffsetDateTime> {
    public DateTimeContextVariableTypeConverter() {
        super(OffsetDateTime.class, s -> {
            if (s instanceof String) {
                return ZonedDateTime.parse((String)s).toOffsetDateTime();
            }
            if (s instanceof OffsetDateTime) {
                return (OffsetDateTime)s;
            }
            return null;
        }, Object::toString, o -> ZonedDateTime.parse(o).toOffsetDateTime(), Arrays.asList(new ContextVariableTypeConverter.DefaultConverter<OffsetDateTime, Instant>(OffsetDateTime.class, Instant.class){

            @Override
            public Instant toObject(OffsetDateTime offsetDateTime) {
                return offsetDateTime.toInstant();
            }
        }));
    }
}

