/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.exceptions;

import com.microsoft.semantickernel.exceptions.SKException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AIException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public AIException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public AIException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public AIException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(AIException.formatDefaultMessage(errorCode.getMessage(), message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCodes {
        UNKNOWN_ERROR("Unknown error"),
        NO_RESPONSE("No response"),
        ACCESS_DENIED("Access is denied"),
        INVALID_REQUEST("The request was invalid"),
        INVALID_RESPONSE_CONTENT("The content of the response was invalid"),
        THROTTLING("The request was throttled"),
        REQUEST_TIMEOUT("The request timed out"),
        SERVICE_ERROR("There was an error in the service"),
        MODEL_NOT_AVAILABLE("The requested model is not available"),
        INVALID_CONFIGURATION("The supplied configuration was invalid"),
        FUNCTION_TYPE_NOT_SUPPORTED("The function is not supported");

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

