/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks;

import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.BlockTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextRendering;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import javax.annotation.Nullable;

public final class FunctionIdBlock
extends Block
implements TextRendering {
    private final String skillName;
    private final String functionName;

    public FunctionIdBlock(String content) {
        super(content, BlockTypes.FUNCTION_ID);
        String[] functionNameParts = this.getContent().split("\\.", -1);
        if (functionNameParts.length > 2) {
            throw new RuntimeException("A function name can contain at most one dot separating the plugin name from the function name");
        }
        if (functionNameParts.length == 2) {
            this.skillName = functionNameParts[0];
            this.functionName = functionNameParts[1];
            return;
        }
        this.functionName = this.getContent();
        this.skillName = "";
    }

    private static boolean hasMoreThanOneDot(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        return value.matches("^.*\\..*\\..*$");
    }

    @Override
    @Nullable
    public String render(@Nullable KernelFunctionArguments variables) {
        return this.getContent();
    }

    @Override
    public boolean isValid() {
        if (!this.getContent().matches("^[a-zA-Z0-9_.]*$")) {
            return false;
        }
        return !FunctionIdBlock.hasMoreThanOneDot(this.getContent());
    }

    public String getPluginName() {
        return this.skillName;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

