/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.hooks.KernelHook;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class FunctionInvocation<T>
extends Mono<FunctionResult<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionInvocation.class);
    protected final KernelFunction<?> function;
    protected final Kernel kernel;
    @Nullable
    protected final ContextVariableType<T> resultType;
    protected final ContextVariableTypes contextVariableTypes = new ContextVariableTypes();
    @Nullable
    protected KernelFunctionArguments arguments;
    @Nullable
    protected KernelHooks.UnmodifiableKernelHooks hooks;
    @Nullable
    protected PromptExecutionSettings promptExecutionSettings;
    @Nullable
    protected ToolCallBehavior toolCallBehavior;
    private boolean isSubscribed = false;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public FunctionInvocation(Kernel kernel, KernelFunction<T> function) {
        this.function = function;
        this.kernel = kernel;
        this.resultType = null;
        this.addKernelHooks(kernel.getGlobalKernelHooks());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public FunctionInvocation(Kernel kernel, KernelFunction<?> function, @Nullable ContextVariableType<T> resultType) {
        this.function = function;
        this.kernel = kernel;
        this.resultType = resultType;
        if (resultType != null) {
            this.contextVariableTypes.putConverter(resultType.getConverter());
        }
        this.addKernelHooks(kernel.getGlobalKernelHooks());
    }

    private static <T> void performSubscribe(CoreSubscriber<? super FunctionResult<T>> coreSubscriber, Kernel kernel, KernelFunction<?> function, @Nullable KernelFunctionArguments arguments, @Nullable ContextVariableType<T> variableType, @Nullable InvocationContext context) {
        if (variableType == null) {
            LOGGER.debug("No variable type explicitly specified by calling 'withResultType' for function invocation: " + function.getPluginName() + "." + function.getName() + ". This may cause a runtime error (probably a ClassCastException) if the result type is not compatible with the expected type.");
        }
        function.invokeAsync(kernel, KernelFunctionArguments.builder().withVariables(arguments).build(), null, new InvocationContext(context)).handle(FunctionInvocation.convertToType(variableType)).subscribe(coreSubscriber);
    }

    private static <T> BiConsumer<FunctionResult<?>, SynchronousSink<FunctionResult<T>>> convertToType(@Nullable ContextVariableType<T> variableType) {
        return (result, sink) -> {
            if (variableType != null) {
                try {
                    sink.next(new FunctionResult(ContextVariable.convert(result.getResult(), variableType), result.getMetadata()));
                }
                catch (Exception e) {
                    sink.error((Throwable)new SKException("Failed to convert result to requested type: " + variableType.getClazz().getName(), e));
                }
            } else {
                sink.next(result);
            }
        };
    }

    @Nullable
    private static KernelHooks.UnmodifiableKernelHooks unmodifiableClone(@Nullable KernelHooks kernelHooks) {
        if (kernelHooks instanceof KernelHooks.UnmodifiableKernelHooks) {
            return (KernelHooks.UnmodifiableKernelHooks)kernelHooks;
        }
        if (kernelHooks != null) {
            return kernelHooks.unmodifiableClone();
        }
        return null;
    }

    public FunctionInvocation<T> withArguments(@Nullable KernelFunctionArguments arguments) {
        this.logSubscribeWarning();
        this.arguments = KernelFunctionArguments.builder().withVariables(arguments).build();
        return this;
    }

    public <U> FunctionInvocation<U> withResultType(ContextVariableType<U> resultType) {
        this.logSubscribeWarning();
        return new FunctionInvocation<U>(this.kernel, this.function, resultType).withArguments(this.arguments).addKernelHooks(this.hooks).withPromptExecutionSettings(this.promptExecutionSettings).withToolCallBehavior(this.toolCallBehavior);
    }

    public FunctionInvocation<T> addKernelHook(@Nullable KernelHook<?> hook) {
        if (hook == null) {
            return this;
        }
        this.logSubscribeWarning();
        KernelHooks clone = new KernelHooks(this.hooks);
        clone.addHook(hook);
        this.hooks = FunctionInvocation.unmodifiableClone(clone);
        return this;
    }

    public FunctionInvocation<T> addKernelHooks(@Nullable KernelHooks hooks) {
        if (hooks == null) {
            return this;
        }
        this.logSubscribeWarning();
        this.hooks = FunctionInvocation.unmodifiableClone(new KernelHooks(this.hooks).addHooks(hooks));
        return this;
    }

    public FunctionInvocation<T> withPromptExecutionSettings(@Nullable PromptExecutionSettings promptExecutionSettings) {
        this.logSubscribeWarning();
        this.promptExecutionSettings = promptExecutionSettings;
        return this;
    }

    public FunctionInvocation<T> withToolCallBehavior(@Nullable ToolCallBehavior toolCallBehavior) {
        this.logSubscribeWarning();
        this.toolCallBehavior = toolCallBehavior;
        return this;
    }

    public FunctionInvocation<T> withTypeConverter(ContextVariableTypeConverter<?> typeConverter) {
        this.logSubscribeWarning();
        this.contextVariableTypes.putConverter(typeConverter);
        return this;
    }

    public FunctionInvocation<T> withTypes(ContextVariableTypes contextVariableTypes) {
        this.logSubscribeWarning();
        this.contextVariableTypes.putConverters(contextVariableTypes);
        return this;
    }

    public FunctionInvocation<T> withInvocationContext(@Nullable InvocationContext invocationContext) {
        if (invocationContext == null) {
            return this;
        }
        this.logSubscribeWarning();
        this.withTypes(invocationContext.getContextVariableTypes());
        this.withToolCallBehavior(invocationContext.getToolCallBehavior());
        this.withPromptExecutionSettings(invocationContext.getPromptExecutionSettings());
        this.addKernelHooks(invocationContext.getKernelHooks());
        return this;
    }

    private void logSubscribeWarning() {
        if (this.isSubscribed) {
            LOGGER.warn("Attempting to modify function {}.{} after it has already been subscribed to. This is not necessarily an error but may be an unusual pattern and indicate a potential bug.", (Object)this.function.getPluginName(), (Object)this.function.getName());
        }
    }

    public void subscribe(CoreSubscriber<? super FunctionResult<T>> coreSubscriber) {
        if (this.isSubscribed) {
            LOGGER.warn("Function {}.{} has already been subscribed to. This is not necessarily an error but may be an unusual pattern.", (Object)this.function.getPluginName(), (Object)this.function.getName());
        }
        this.isSubscribed = true;
        FunctionInvocation.performSubscribe(coreSubscriber, this.kernel, this.function, this.arguments, this.resultType, new InvocationContext(this.hooks, this.promptExecutionSettings, this.toolCallBehavior, this.contextVariableTypes));
    }
}

