/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class PromptExecutionSettings {
    public static final String DEFAULT_SERVICE_ID = "default";
    public static final Integer DEFAULT_MAX_TOKENS = 256;
    public static final Double DEFAULT_TEMPERATURE = 1.0;
    public static final Double DEFAULT_TOP_P = 1.0;
    public static final Double DEFAULT_PRESENCE_PENALTY = 0.0;
    public static final Double DEFAULT_FREQUENCY_PENALTY = 0.0;
    public static final Integer DEFAULT_BEST_OF = 1;
    public static final Integer DEFAULT_RESULTS_PER_PROMPT = 1;
    private static final String SERVICE_ID = "service_id";
    private static final String MODEL_ID = "model_id";
    private static final String TEMPERATURE = "temperature";
    private static final String TOP_P = "top_p";
    private static final String PRESENCE_PENALTY = "presence_penalty";
    private static final String FREQUENCY_PENALTY = "frequency_penalty";
    private static final String MAX_TOKENS = "max_tokens";
    private static final String BEST_OF = "best_of";
    private static final String USER = "user";
    private static final String STOP_SEQUENCES = "stop_sequences";
    private static final String RESULTS_PER_PROMPT = "results_per_prompt";
    private static final String TOKEN_SELECTION_BIASES = "token_selection_biases";
    private final String serviceId;
    private final String modelId;
    private final double temperature;
    private final double topP;
    private final double presencePenalty;
    private final double frequencyPenalty;
    private final int maxTokens;
    private final int bestOf;
    private final int resultsPerPrompt;
    private final String user;
    @Nullable
    private final List<String> stopSequences;
    private final Map<Integer, Integer> tokenSelectionBiases;

    @JsonCreator
    public PromptExecutionSettings(@JsonProperty(value="service_id") String serviceId, @JsonProperty(value="model_id") String modelId, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="frequency_penalty") Double frequencyPenalty, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="results_per_prompt") Integer resultsPerPrompt, @JsonProperty(value="best_of") Integer bestOf, @JsonProperty(value="user") String user, @Nullable @JsonProperty(value="stop_sequences") List<String> stopSequences, @Nullable @JsonProperty(value="token_selection_biases") Map<Integer, Integer> tokenSelectionBiases) {
        this.serviceId = serviceId;
        this.modelId = modelId;
        this.temperature = PromptExecutionSettings.clamp(temperature, 0.0, 2.0, DEFAULT_TEMPERATURE);
        this.topP = PromptExecutionSettings.clamp(topP, 0.0, 1.0, DEFAULT_TOP_P);
        this.presencePenalty = PromptExecutionSettings.clamp(presencePenalty, -2.0, 2.0, DEFAULT_PRESENCE_PENALTY);
        this.frequencyPenalty = PromptExecutionSettings.clamp(frequencyPenalty, -2.0, 2.0, DEFAULT_FREQUENCY_PENALTY);
        this.maxTokens = PromptExecutionSettings.clamp(maxTokens, 1, Integer.MAX_VALUE, DEFAULT_MAX_TOKENS);
        this.resultsPerPrompt = PromptExecutionSettings.clamp(resultsPerPrompt, 1, Integer.MAX_VALUE, DEFAULT_RESULTS_PER_PROMPT);
        this.bestOf = PromptExecutionSettings.clamp(bestOf, 1, Integer.MAX_VALUE, DEFAULT_BEST_OF);
        this.user = user;
        this.stopSequences = stopSequences != null ? new ArrayList<String>(stopSequences) : Collections.emptyList();
        this.tokenSelectionBiases = tokenSelectionBiases != null ? new HashMap<Integer, Integer>(tokenSelectionBiases) : Collections.emptyMap();
        this.tokenSelectionBiases.replaceAll((k, v) -> PromptExecutionSettings.clamp(v, -100, 100, 0));
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T extends Number> T clamp(T value, T min, T max, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.doubleValue() < min.doubleValue()) {
            return min;
        }
        if (value.doubleValue() > max.doubleValue()) {
            return max;
        }
        return value;
    }

    @JsonProperty(value="service_id")
    public String getServiceId() {
        return this.serviceId;
    }

    @JsonProperty(value="model_id")
    public String getModelId() {
        return this.modelId;
    }

    @JsonProperty(value="temperature")
    public double getTemperature() {
        return Double.isNaN(this.temperature) ? DEFAULT_TEMPERATURE : this.temperature;
    }

    @JsonProperty(value="top_p")
    public double getTopP() {
        return this.topP;
    }

    @JsonProperty(value="presence_penalty")
    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty(value="max_tokens")
    public int getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="results_per_prompt")
    public int getResultsPerPrompt() {
        return this.resultsPerPrompt;
    }

    @JsonProperty(value="best_of")
    public int getBestOf() {
        return this.bestOf;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="stop_sequences")
    @Nullable
    public List<String> getStopSequences() {
        if (this.stopSequences != null) {
            return Collections.unmodifiableList(this.stopSequences);
        }
        return null;
    }

    @JsonProperty(value="token_selection_biases")
    @Nullable
    public Map<Integer, Integer> getTokenSelectionBiases() {
        if (this.tokenSelectionBiases != null) {
            return Collections.unmodifiableMap(this.tokenSelectionBiases);
        }
        return null;
    }

    public static class Builder {
        Map<String, Object> settings = new HashMap<String, Object>();

        public Builder withServiceId(String serviceId) {
            this.settings.put(PromptExecutionSettings.SERVICE_ID, serviceId);
            return this;
        }

        public Builder withModelId(String modelId) {
            this.settings.put(PromptExecutionSettings.MODEL_ID, modelId);
            return this;
        }

        public Builder withTemperature(double temperature) {
            if (!Double.isNaN(temperature)) {
                this.settings.put(PromptExecutionSettings.TEMPERATURE, temperature);
            }
            return this;
        }

        public Builder withTopP(double topP) {
            if (!Double.isNaN(topP)) {
                this.settings.put(PromptExecutionSettings.TOP_P, topP);
            }
            return this;
        }

        public Builder withPresencePenalty(double presencePenalty) {
            if (!Double.isNaN(presencePenalty)) {
                this.settings.put(PromptExecutionSettings.PRESENCE_PENALTY, presencePenalty);
            }
            return this;
        }

        public Builder withFrequencyPenalty(double frequencyPenalty) {
            if (!Double.isNaN(frequencyPenalty)) {
                this.settings.put(PromptExecutionSettings.FREQUENCY_PENALTY, frequencyPenalty);
            }
            return this;
        }

        public Builder withMaxTokens(int maxTokens) {
            this.settings.put(PromptExecutionSettings.MAX_TOKENS, maxTokens);
            return this;
        }

        public Builder withResultsPerPrompt(int resultsPerPrompt) {
            this.settings.put(PromptExecutionSettings.RESULTS_PER_PROMPT, resultsPerPrompt);
            return this;
        }

        public Builder withBestOf(int bestOf) {
            this.settings.put(PromptExecutionSettings.BEST_OF, bestOf);
            return this;
        }

        public Builder withUser(String user) {
            this.settings.put(PromptExecutionSettings.USER, user);
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            if (stopSequences != null) {
                ((List)this.settings.computeIfAbsent(PromptExecutionSettings.STOP_SEQUENCES, k -> new ArrayList())).addAll(stopSequences);
            }
            return this;
        }

        public Builder withTokenSelectionBiases(Map<Integer, Integer> tokenSelectionBiases) {
            if (tokenSelectionBiases != null) {
                ((Map)this.settings.computeIfAbsent(PromptExecutionSettings.TOKEN_SELECTION_BIASES, k -> new HashMap())).putAll(tokenSelectionBiases);
            }
            return this;
        }

        public PromptExecutionSettings build() {
            return new PromptExecutionSettings((String)this.settings.getOrDefault(PromptExecutionSettings.SERVICE_ID, ""), (String)this.settings.getOrDefault(PromptExecutionSettings.MODEL_ID, ""), (Double)this.settings.getOrDefault(PromptExecutionSettings.TEMPERATURE, DEFAULT_TEMPERATURE), (Double)this.settings.getOrDefault(PromptExecutionSettings.TOP_P, DEFAULT_TOP_P), (Double)this.settings.getOrDefault(PromptExecutionSettings.PRESENCE_PENALTY, DEFAULT_PRESENCE_PENALTY), (Double)this.settings.getOrDefault(PromptExecutionSettings.FREQUENCY_PENALTY, DEFAULT_FREQUENCY_PENALTY), (Integer)this.settings.getOrDefault(PromptExecutionSettings.MAX_TOKENS, DEFAULT_MAX_TOKENS), (Integer)this.settings.getOrDefault(PromptExecutionSettings.RESULTS_PER_PROMPT, DEFAULT_RESULTS_PER_PROMPT), (Integer)this.settings.getOrDefault(PromptExecutionSettings.BEST_OF, DEFAULT_BEST_OF), (String)this.settings.getOrDefault(PromptExecutionSettings.USER, ""), this.settings.getOrDefault(PromptExecutionSettings.STOP_SEQUENCES, Collections.emptyList()), this.settings.getOrDefault(PromptExecutionSettings.TOKEN_SELECTION_BIASES, Collections.emptyMap()));
        }
    }
}

