/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ToolCallBehavior {
    private static final int DEFAULT_MAXIMUM_AUTO_INVOKE_ATTEMPTS = 5;
    private static final String FUNCTION_NAME_SEPARATOR = "-";
    private final int maximumAutoInvokeAttempts;

    public static ToolCallBehavior allowAllKernelFunctions(boolean autoInvoke) {
        return new AllowedKernelFunctions(true, autoInvoke, null);
    }

    public static ToolCallBehavior requireKernelFunction(KernelFunction<?> function) {
        return new RequiredKernelFunction(function);
    }

    public static ToolCallBehavior allowOnlyKernelFunctions(boolean autoInvoke, List<KernelFunction<?>> functions) {
        return new AllowedKernelFunctions(false, autoInvoke, functions);
    }

    public static ToolCallBehavior allowOnlyKernelFunctions(boolean autoInvoke, KernelFunction<?> ... functions) {
        return ToolCallBehavior.allowOnlyKernelFunctions(autoInvoke, Arrays.asList(functions));
    }

    private ToolCallBehavior(int maximumAutoInvokeAttempts) {
        this.maximumAutoInvokeAttempts = maximumAutoInvokeAttempts;
    }

    public boolean isAutoInvokeAllowed() {
        return this.maximumAutoInvokeAttempts > 0;
    }

    public int getMaximumAutoInvokeAttempts() {
        return this.maximumAutoInvokeAttempts;
    }

    public static String formFullFunctionName(@Nullable String pluginName, String functionName) {
        if (pluginName == null) {
            pluginName = "";
        }
        return String.format("%s%s%s", pluginName, FUNCTION_NAME_SEPARATOR, functionName);
    }

    public static class AllowedKernelFunctions
    extends ToolCallBehavior {
        private final Set<String> allowedFunctions;
        private final boolean allKernelFunctionsAllowed;

        public AllowedKernelFunctions(boolean allKernelFunctionsAllowed, boolean autoInvoke, @Nullable List<KernelFunction<?>> allowedFunctions) {
            super(autoInvoke ? 5 : 0);
            this.allKernelFunctionsAllowed = allKernelFunctionsAllowed;
            this.allowedFunctions = new HashSet<String>();
            if (allowedFunctions != null) {
                allowedFunctions.stream().filter(Objects::nonNull).forEach(f -> this.allowedFunctions.add(AllowedKernelFunctions.formFullFunctionName(f.getPluginName(), f.getName())));
            }
        }

        public boolean isFunctionAllowed(KernelFunction<?> function) {
            return this.isFunctionAllowed(function.getPluginName(), function.getName());
        }

        public boolean isFunctionAllowed(@Nullable String pluginName, String functionName) {
            String key = AllowedKernelFunctions.formFullFunctionName(pluginName, functionName);
            return this.allowedFunctions.contains(key);
        }

        public boolean isAllKernelFunctionsAllowed() {
            return this.allKernelFunctionsAllowed;
        }
    }

    public static class RequiredKernelFunction
    extends ToolCallBehavior {
        private final KernelFunction<?> requiredFunction;

        public RequiredKernelFunction(KernelFunction<?> requiredFunction) {
            super(1);
            this.requiredFunction = requiredFunction;
        }

        public KernelFunction<?> getRequiredFunction() {
            return this.requiredFunction;
        }
    }
}

