/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.exceptions.SKException;
import javax.annotation.Nullable;

public class InputVariable {
    private String name;
    private String type;
    @Nullable
    private String description;
    @Nullable
    private String defaultValue;
    private boolean isRequired;

    public InputVariable(String name) {
        this.name = name;
        this.type = String.class.getName();
        this.description = null;
        this.defaultValue = null;
        this.isRequired = true;
    }

    @JsonCreator
    public InputVariable(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="default") @Nullable String defaultValue, @JsonProperty(value="is_required") boolean isRequired) {
        this.name = name;
        if (type == null) {
            type = "java.lang.String";
        }
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public Class<?> getTypeClass() {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(this.type);
        }
        catch (ClassNotFoundException e) {
            throw new SKException("Could not load class for type: " + this.type + " for input variable " + this.name + ". This needs to be a fully qualified class name, e.g. 'java.lang.String'.");
        }
    }
}

