/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionFromPrompt;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nullable;

public class KernelFunctionYaml {
    public static <T> KernelFunction<T> fromPromptYaml(String yaml, @Nullable PromptTemplateFactory promptTemplateFactory) throws IOException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(yaml.getBytes(StandardCharsets.UTF_8));
        return KernelFunctionYaml.fromYaml(targetStream, promptTemplateFactory);
    }

    public static <T> KernelFunction<T> fromPromptYaml(String yaml) throws IOException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(yaml.getBytes(StandardCharsets.UTF_8));
        return KernelFunctionYaml.fromYaml(targetStream, null);
    }

    public static <T> KernelFunction<T> fromYaml(Path filePath) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath.toString());
        return KernelFunctionYaml.fromYaml(inputStream, null);
    }

    private static <T> KernelFunction<T> fromYaml(InputStream inputStream, @Nullable PromptTemplateFactory promptTemplateFactory) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        PromptTemplateConfig functionModel = (PromptTemplateConfig)mapper.readValue(inputStream, PromptTemplateConfig.class);
        PromptTemplate promptTemplate = promptTemplateFactory == null ? PromptTemplateFactory.build(functionModel) : promptTemplateFactory.tryCreate(functionModel);
        return new KernelFunctionFromPrompt.Builder().withName(functionModel.getName()).withInputParameters(functionModel.getInputVariables()).withPromptTemplate(promptTemplate).withExecutionSettings(functionModel.getExecutionSettings()).withDescription(functionModel.getDescription()).withOutputVariable(functionModel.getOutputVariable()).build();
    }
}

