/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.exceptions.SKException;
import javax.annotation.Nullable;

public class OutputVariable {
    @Nullable
    private final String description;
    private final String type;

    @JsonCreator
    public OutputVariable(@Nullable @JsonProperty(value="description") String description, @Nullable @JsonProperty(value="type", defaultValue="java.lang.String") String type) {
        this.description = description;
        if (type == null || type.isEmpty()) {
            type = "java.lang.String";
        }
        this.type = type;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Class<?> getType() {
        try {
            return this.getClass().getClassLoader().loadClass(this.type);
        }
        catch (ClassNotFoundException e) {
            throw new SKException("Requested output type could not be found: " + this.type + ". This needs to be a fully qualified class name, e.g. 'java.lang.String'.");
        }
    }
}

