/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.chatcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.builders.Buildable;
import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.implementation.ServiceLoadUtil;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.services.TextAIService;
import com.microsoft.semantickernel.services.chatcompletion.ChatHistory;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import java.util.List;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public interface ChatCompletionService
extends Buildable,
TextAIService {
    public static Builder builder() {
        return ServiceLoadUtil.findServiceLoader(Builder.class, "com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIChatCompletion$Builder").get();
    }

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(ChatHistory var1, @Nullable Kernel var2, @Nullable InvocationContext var3);

    public Mono<List<ChatMessageContent<?>>> getChatMessageContentsAsync(String var1, @Nullable Kernel var2, @Nullable InvocationContext var3);

    public static abstract class Builder
    implements SemanticKernelBuilder<ChatCompletionService> {
        @Nullable
        protected OpenAIAsyncClient client;
        @Nullable
        protected String modelId;
        @Nullable
        protected String serviceId;

        public Builder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder withOpenAIAsyncClient(OpenAIAsyncClient openAIClient) {
            this.client = openAIClient;
            return this;
        }

        public Builder withServiceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }
    }
}

