/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.chatcompletion;

import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ChatHistory
implements Iterable<ChatMessageContent<?>> {
    private static final String DEFAULT_CHAT_SYSTEM_PROMPT = "Assistant is a large language model.";
    private final List<ChatMessageContent<?>> chatMessageContents;

    public ChatHistory() {
        this(DEFAULT_CHAT_SYSTEM_PROMPT);
    }

    public ChatHistory(String instructions) {
        this.chatMessageContents = new ArrayList();
        this.chatMessageContents.add(new ChatMessageContent(AuthorRole.ASSISTANT, instructions == null || instructions.isEmpty() ? DEFAULT_CHAT_SYSTEM_PROMPT : instructions));
    }

    public ChatHistory(List<ChatMessageContent<?>> chatMessageContents) {
        this.chatMessageContents = new ArrayList(chatMessageContents);
    }

    public List<ChatMessageContent<?>> getMessages() {
        return Collections.unmodifiableList(this.chatMessageContents);
    }

    public Optional<ChatMessageContent<?>> getLastMessage() {
        if (this.chatMessageContents.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.chatMessageContents.get(this.chatMessageContents.size() - 1));
    }

    public void addAll(ChatHistory value) {
        this.chatMessageContents.addAll(value.getMessages());
    }

    @Override
    public Iterator<ChatMessageContent<?>> iterator() {
        return this.chatMessageContents.iterator();
    }

    @Override
    public void forEach(Consumer<? super ChatMessageContent<?>> action) {
        this.chatMessageContents.forEach(action);
    }

    @Override
    public Spliterator<ChatMessageContent<?>> spliterator() {
        return this.chatMessageContents.spliterator();
    }

    public void addMessage(AuthorRole authorRole, String content, Charset encoding, FunctionResultMetadata metadata) {
        this.chatMessageContents.add(new ChatMessageContent<Object>(authorRole, content, null, null, encoding, metadata));
    }

    public void addMessage(AuthorRole authorRole, String content) {
        this.chatMessageContents.add(new ChatMessageContent<Object>(authorRole, content, null, null, null, null));
    }

    public void addMessage(ChatMessageContent<?> content) {
        this.chatMessageContents.add(content);
    }

    public void addUserMessage(String content) {
        this.addMessage(AuthorRole.USER, content);
    }

    public void addAssistantMessage(String content) {
        this.addMessage(AuthorRole.ASSISTANT, content);
    }

    public void addSystemMessage(String content) {
        this.addMessage(AuthorRole.SYSTEM, content);
    }
}

