/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public class InvocationContext {
    @Nullable
    private final KernelHooks.UnmodifiableKernelHooks hooks;
    @Nullable
    private final PromptExecutionSettings promptExecutionSettings;
    @Nullable
    private final ToolCallBehavior toolCallBehavior;
    private final ContextVariableTypes contextVariableTypes;

    protected InvocationContext(@Nullable KernelHooks hooks, @Nullable PromptExecutionSettings promptExecutionSettings, @Nullable ToolCallBehavior toolCallBehavior, @Nullable ContextVariableTypes contextVariableTypes) {
        this.hooks = InvocationContext.unmodifiableClone(hooks);
        this.promptExecutionSettings = promptExecutionSettings;
        this.toolCallBehavior = toolCallBehavior;
        this.contextVariableTypes = contextVariableTypes == null ? new ContextVariableTypes() : new ContextVariableTypes(contextVariableTypes);
    }

    protected InvocationContext() {
        this.hooks = null;
        this.promptExecutionSettings = null;
        this.toolCallBehavior = null;
        this.contextVariableTypes = new ContextVariableTypes();
    }

    protected InvocationContext(@Nullable InvocationContext context) {
        if (context == null) {
            this.hooks = null;
            this.promptExecutionSettings = null;
            this.toolCallBehavior = null;
            this.contextVariableTypes = new ContextVariableTypes();
        } else {
            this.hooks = context.hooks;
            this.promptExecutionSettings = context.promptExecutionSettings;
            this.toolCallBehavior = context.toolCallBehavior;
            this.contextVariableTypes = context.contextVariableTypes;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    private static KernelHooks.UnmodifiableKernelHooks unmodifiableClone(@Nullable KernelHooks kernelHooks) {
        if (kernelHooks instanceof KernelHooks.UnmodifiableKernelHooks) {
            return (KernelHooks.UnmodifiableKernelHooks)kernelHooks;
        }
        if (kernelHooks != null) {
            return kernelHooks.unmodifiableClone();
        }
        return null;
    }

    public static Builder copy(InvocationContext context) {
        return new Builder().withKernelHooks(context.getKernelHooks()).withContextVariableConverter(context.contextVariableTypes).withPromptExecutionSettings(context.getPromptExecutionSettings()).withToolCallBehavior(context.getToolCallBehavior());
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="returns UnmodifiableKernelHooks")
    public KernelHooks.UnmodifiableKernelHooks getKernelHooks() {
        return this.hooks;
    }

    @Nullable
    public PromptExecutionSettings getPromptExecutionSettings() {
        return this.promptExecutionSettings;
    }

    @Nullable
    public ToolCallBehavior getToolCallBehavior() {
        return this.toolCallBehavior;
    }

    public ContextVariableTypes getContextVariableTypes() {
        return new ContextVariableTypes(this.contextVariableTypes);
    }

    public static class Builder
    implements SemanticKernelBuilder<InvocationContext> {
        private final ContextVariableTypes contextVariableTypes = new ContextVariableTypes();
        @Nullable
        private KernelHooks.UnmodifiableKernelHooks hooks;
        @Nullable
        private PromptExecutionSettings promptExecutionSettings;
        @Nullable
        private ToolCallBehavior toolCallBehavior;

        public Builder withKernelHooks(@Nullable KernelHooks hooks) {
            this.hooks = InvocationContext.unmodifiableClone(hooks);
            return this;
        }

        public Builder withPromptExecutionSettings(@Nullable PromptExecutionSettings promptExecutionSettings) {
            this.promptExecutionSettings = promptExecutionSettings;
            return this;
        }

        public Builder withToolCallBehavior(@Nullable ToolCallBehavior toolCallBehavior) {
            this.toolCallBehavior = toolCallBehavior;
            return this;
        }

        public Builder withContextVariableConverter(ContextVariableTypeConverter<?> converter) {
            this.contextVariableTypes.putConverter(converter);
            return this;
        }

        public Builder withContextVariableConverter(ContextVariableTypes contextVariableTypes) {
            this.contextVariableTypes.putConverters(contextVariableTypes);
            return this;
        }

        @Override
        public InvocationContext build() {
            return new InvocationContext(this.hooks, this.promptExecutionSettings, this.toolCallBehavior, this.contextVariableTypes);
        }
    }
}

