/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.templateengine.handlebars;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.ValueResolver;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.plugin.KernelPlugin;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class HandlebarsPromptTemplate
implements PromptTemplate {
    private final PromptTemplateConfig promptTemplate;

    public HandlebarsPromptTemplate(@Nonnull PromptTemplateConfig promptTemplate) {
        this.promptTemplate = new PromptTemplateConfig(promptTemplate);
    }

    @Override
    public Mono<String> renderAsync(Kernel kernel, @Nullable KernelFunctionArguments arguments, @Nullable InvocationContext context) {
        String template = this.promptTemplate.getTemplate();
        if (template == null) {
            return Mono.error((Throwable)new SKException(String.format("No prompt template was provided for the prompt %s.", this.promptTemplate.getName())));
        }
        if (context == null) {
            context = InvocationContext.builder().build();
        }
        HandleBarsPromptTemplateHandler handler = new HandleBarsPromptTemplateHandler(kernel, template, context);
        if (arguments == null) {
            arguments = KernelFunctionArguments.builder().build();
        }
        return handler.render(arguments);
    }

    private static void addFunctionHelpers(Kernel kernel, Handlebars handlebars, InvocationContext context) {
        kernel.getPlugins().forEach(plugin -> plugin.iterator().forEachRemaining(kernelFunction -> {
            String functionName = kernelFunction.getName();
            String pluginName = plugin.getName();
            handlebars.registerHelper(ToolCallBehavior.formFullFunctionName(pluginName, functionName), HandlebarsPromptTemplate.functionInvokeHelper(kernel, kernelFunction, context));
        }));
    }

    private static Helper<Object> functionInvokeHelper(Kernel kernel, KernelFunction<?> kernelFunction, InvocationContext invocationContext) {
        return (context, options) -> {
            KernelFunctionArguments.Builder builder = KernelFunctionArguments.builder();
            if (context instanceof KernelFunctionArguments) {
                builder.withVariables((KernelFunctionArguments)context);
            } else {
                builder.withInput(context);
            }
            if (options.hash("input") != null) {
                builder.withVariables(options.hash.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> invocationContext.getContextVariableTypes().contextVariableOf(entry.getValue()))));
            }
            return ((FunctionResult)kernelFunction.invokeAsync(kernel).withArguments(builder.build()).block()).getResult();
        };
    }

    private static class HandleBarsPromptTemplateHandler {
        private final String template;
        private final Handlebars handlebars;

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
        public HandleBarsPromptTemplateHandler(Kernel kernel, String template, InvocationContext context) {
            this.template = template;
            this.handlebars = new Handlebars();
            this.handlebars.registerHelper("message", HandleBarsPromptTemplateHandler::handleMessage).registerHelper("each", HandleBarsPromptTemplateHandler.handleEach(context)).with(EscapingStrategy.XML);
            HandlebarsPromptTemplate.addFunctionHelpers(kernel, this.handlebars, context);
        }

        private static Helper<Object> handleEach(InvocationContext invocationContext) {
            return (context, options) -> {
                if (context instanceof ContextVariable) {
                    return ((ContextVariable)context).toPromptString(invocationContext.getContextVariableTypes());
                }
                if (context instanceof Iterable) {
                    StringBuilder sb = new StringBuilder();
                    for (Object element : (Iterable)context) {
                        if (element instanceof KernelPlugin) {
                            KernelPlugin plugin = (KernelPlugin)element;
                            for (KernelFunction<?> function : plugin) {
                                sb.append(options.fn(function));
                            }
                            continue;
                        }
                        sb.append(options.fn(element));
                    }
                    return new Handlebars.SafeString((CharSequence)sb.toString());
                }
                ContextVariableType<?> type = invocationContext.getContextVariableTypes().getVariableTypeForClass(context.getClass());
                if (type != null) {
                    return type.getConverter().toPromptString(invocationContext.getContextVariableTypes(), context);
                }
                return null;
            };
        }

        @Nullable
        private static CharSequence handleMessage(Object context, Options options) throws IOException {
            ChatMessageContent message;
            String role = (String)options.hash("role");
            String content = (String)options.fn(context);
            if (context instanceof Optional && (message = (ChatMessageContent)((Optional)context).orElse(null)) != null) {
                if (role == null || role.isEmpty()) {
                    role = message.getAuthorRole().name();
                }
                content = message.getContent();
            }
            if (role != null && !role.isEmpty()) {
                return new Handlebars.SafeString((CharSequence)String.format("<message role=\"%s\">%s</message>", role.toLowerCase(Locale.ROOT), content));
            }
            return null;
        }

        public Mono<String> render(KernelFunctionArguments variables) {
            try {
                ArrayList<Object> resolvers = new ArrayList<Object>();
                resolvers.add(new MessageResolver());
                resolvers.add(new ContextVariableResolver());
                Context context = Context.newBuilder((Object)variables).resolver(resolvers.toArray(new ValueResolver[0])).build();
                String result = this.handlebars.compileInline(this.template).apply(context);
                return Mono.just((Object)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ContextVariableResolver
    implements ValueResolver {
        private ContextVariableResolver() {
        }

        public Object resolve(Object context, String name) {
            Object value = null;
            if (context instanceof KernelFunctionArguments) {
                ContextVariable<?> variable = ((KernelFunctionArguments)context).get(name);
                Object object = value = variable != null ? variable.getValue() : UNRESOLVED;
            }
            if (context instanceof ContextVariable) {
                value = ((ContextVariable)context).getValue();
            }
            if (value == null) {
                return UNRESOLVED;
            }
            return value;
        }

        public Object resolve(Object context) {
            if (context instanceof ContextVariable) {
                Object result = ((ContextVariable)context).getValue();
                return result != null ? result : UNRESOLVED;
            }
            return UNRESOLVED;
        }

        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            if (context instanceof KernelFunctionArguments) {
                HashMap result = new HashMap();
                result.putAll((KernelFunctionArguments)context);
                return result.entrySet();
            }
            if (context instanceof ContextVariable) {
                HashMap result = new HashMap();
                result.put("value", ((ContextVariable)context).getValue());
                return result.entrySet();
            }
            return new HashSet<Map.Entry<String, Object>>();
        }
    }

    private static class MessageResolver
    implements ValueResolver {
        private MessageResolver() {
        }

        public Object resolve(Object context, String name) {
            if (context instanceof ChatMessageContent) {
                if ("role".equalsIgnoreCase(name)) {
                    return ((ChatMessageContent)context).getAuthorRole().name();
                }
                if ("content".equalsIgnoreCase(name)) {
                    return ContextVariableTypeConverter.escapeXmlString(((ChatMessageContent)context).getContent());
                }
            }
            return UNRESOLVED;
        }

        public Object resolve(Object context) {
            if (context instanceof ChatMessageContent) {
                String content = ((ChatMessageContent)context).getContent();
                if (content == null) {
                    return UNRESOLVED;
                }
                return String.format("<message role=\"%s\">%s</message>", ((ChatMessageContent)context).getAuthorRole().toString().toLowerCase(Locale.ROOT), ContextVariableTypeConverter.escapeXmlString(content));
            }
            return UNRESOLVED;
        }

        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            if (context instanceof ChatMessageContent) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("role", ((ChatMessageContent)context).getAuthorRole().name());
                result.put("content", ((ChatMessageContent)context).getContent());
                return result.entrySet();
            }
            return new HashSet<Map.Entry<String, Object>>();
        }
    }
}

