/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.OutputVariable;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PromptTemplateConfig {
    public static final int CURRENT_SCHEMA = 1;
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final String SEMANTIC_KERNEL_TEMPLATE_FORMAT = "semantic-kernel";
    private final int schema;
    @Nullable
    private final String name;
    @Nullable
    private final String template;
    private final String templateFormat;
    private final Set<PromptTemplateOption> promptTemplateOptions;
    @Nullable
    private final String description;
    private final List<InputVariable> inputVariables;
    @Nullable
    private final OutputVariable outputVariable;
    private final Map<String, PromptExecutionSettings> executionSettings;

    protected PromptTemplateConfig(String template) {
        this(1, DEFAULT_CONFIG_NAME, template, SEMANTIC_KERNEL_TEMPLATE_FORMAT, Collections.emptySet(), "", Collections.emptyList(), new OutputVariable(String.class.getName(), "out"), Collections.emptyMap());
    }

    @JsonCreator
    public PromptTemplateConfig(@Nullable @JsonProperty(value="schema") Integer schema, @Nullable @JsonProperty(value="name") String name, @Nullable @JsonProperty(value="template") String template, @Nullable @JsonProperty(value="template_format", defaultValue="semantic-kernel") String templateFormat, @Nullable @JsonProperty(value="prompt_template_options") Set<PromptTemplateOption> promptTemplateOptions, @Nullable @JsonProperty(value="description") String description, @Nullable @JsonProperty(value="input_variables") List<InputVariable> inputVariables, @Nullable @JsonProperty(value="output_variable") OutputVariable outputVariable, @Nullable @JsonProperty(value="execution_settings") Map<String, PromptExecutionSettings> executionSettings) {
        if (schema == null) {
            schema = 1;
        }
        this.schema = schema;
        this.name = name;
        this.template = template;
        if (templateFormat == null) {
            templateFormat = SEMANTIC_KERNEL_TEMPLATE_FORMAT;
        }
        this.templateFormat = templateFormat;
        if (promptTemplateOptions == null) {
            promptTemplateOptions = new HashSet<PromptTemplateOption>();
        }
        this.promptTemplateOptions = promptTemplateOptions;
        this.description = description;
        this.inputVariables = inputVariables == null ? new ArrayList<InputVariable>() : new ArrayList<InputVariable>(inputVariables);
        this.outputVariable = outputVariable != null ? outputVariable : new OutputVariable(String.class.getName(), "out");
        this.executionSettings = executionSettings == null ? new HashMap<String, PromptExecutionSettings>() : new HashMap<String, PromptExecutionSettings>(executionSettings);
    }

    protected PromptTemplateConfig(@Nullable String name, @Nullable String template, @Nullable String templateFormat, @Nullable Set<PromptTemplateOption> promptTemplateOptions, @Nullable String description, @Nullable List<InputVariable> inputVariables, @Nullable OutputVariable outputVariable, @Nullable Map<String, PromptExecutionSettings> executionSettings) {
        this(1, name, template, templateFormat, promptTemplateOptions, description, inputVariables, outputVariable, executionSettings);
    }

    public PromptTemplateConfig(PromptTemplateConfig promptTemplate) {
        this(promptTemplate.name, promptTemplate.template, promptTemplate.templateFormat, promptTemplate.promptTemplateOptions, promptTemplate.description, promptTemplate.inputVariables, promptTemplate.outputVariable, promptTemplate.executionSettings);
    }

    public static PromptTemplateConfig parseFromJson(String json) throws SKException {
        try {
            return (PromptTemplateConfig)new ObjectMapper().readValue(json, PromptTemplateConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new SKException("Unable to parse prompt template config", e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder defaultTemplateBuilder() {
        return new Builder().withName(DEFAULT_CONFIG_NAME);
    }

    public List<InputVariable> getKernelParametersMetadata() {
        if (this.inputVariables == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.inputVariables);
    }

    public OutputVariable<?> getKernelReturnParameterMetadata() {
        if (this.outputVariable == null) {
            return new OutputVariable<String>("", String.class);
        }
        return new OutputVariable(this.outputVariable.getDescription(), this.outputVariable.getType());
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTemplate() {
        return this.template;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public List<InputVariable> getInputVariables() {
        return Collections.unmodifiableList(this.inputVariables);
    }

    @Nullable
    public OutputVariable getOutputVariable() {
        return this.outputVariable;
    }

    @Nullable
    public Map<String, PromptExecutionSettings> getExecutionSettings() {
        if (this.executionSettings != null) {
            return Collections.unmodifiableMap(this.executionSettings);
        }
        return null;
    }

    public String getTemplateFormat() {
        return this.templateFormat;
    }

    public int getSchema() {
        return this.schema;
    }

    public Set<PromptTemplateOption> getPromptTemplateOptions() {
        return Collections.unmodifiableSet(this.promptTemplateOptions);
    }

    public Builder copy() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.template, this.templateFormat, this.description, this.inputVariables, this.outputVariable, this.executionSettings);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        PromptTemplateConfig other = (PromptTemplateConfig)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.template, other.template)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.templateFormat, other.templateFormat)) {
            return false;
        }
        if (!Objects.equals(this.inputVariables, other.inputVariables)) {
            return false;
        }
        if (!Objects.equals(this.outputVariable, other.outputVariable)) {
            return false;
        }
        return Objects.equals(this.executionSettings, other.executionSettings);
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String template;
        private String templateFormat = "semantic-kernel";
        private final Set<PromptTemplateOption> promptTemplateOptions = new HashSet<PromptTemplateOption>();
        @Nullable
        private String description = null;
        private List<InputVariable> inputVariables = new ArrayList<InputVariable>();
        @Nullable
        private OutputVariable outputVariable;
        private Map<String, PromptExecutionSettings> executionSettings = new HashMap<String, PromptExecutionSettings>();

        private Builder() {
        }

        private Builder(PromptTemplateConfig promptTemplateConfig) {
            this.name = promptTemplateConfig.name;
            this.template = promptTemplateConfig.template;
            this.templateFormat = promptTemplateConfig.templateFormat;
            this.description = promptTemplateConfig.description;
            this.inputVariables = new ArrayList<InputVariable>(promptTemplateConfig.inputVariables);
            this.outputVariable = promptTemplateConfig.outputVariable;
            this.executionSettings = new HashMap<String, PromptExecutionSettings>(promptTemplateConfig.executionSettings);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder addInputVariable(InputVariable inputVariable) {
            this.inputVariables.add(inputVariable);
            return this;
        }

        public Builder withTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withTemplateFormat(String templateFormat) {
            this.templateFormat = templateFormat;
            return this;
        }

        public Builder addPromptTemplateOption(PromptTemplateOption option) {
            this.promptTemplateOptions.add(option);
            return this;
        }

        public Builder withInputVariables(List<InputVariable> inputVariables) {
            this.inputVariables = new ArrayList<InputVariable>(inputVariables);
            return this;
        }

        public Builder withOutputVariable(OutputVariable<?> outputVariable) {
            this.outputVariable = outputVariable;
            return this;
        }

        public Builder withExecutionSettings(Map<String, PromptExecutionSettings> executionSettings) {
            this.executionSettings = new HashMap<String, PromptExecutionSettings>(executionSettings);
            return this;
        }

        public PromptTemplateConfig build() {
            return new PromptTemplateConfig(this.name, this.template, this.templateFormat, this.promptTemplateOptions, this.description, this.inputVariables, this.outputVariable, this.executionSettings);
        }
    }
}

