/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.Verify;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.TemplateTokenizer;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.BlockTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.CodeRendering;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.NamedArgBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextRendering;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.VarBlock;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.templateengine.semantickernel.TemplateException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultPromptTemplate
implements PromptTemplate {
    private final PromptTemplateConfig promptTemplateConfig;
    private final List<Block> blocks;

    private DefaultPromptTemplate(@Nonnull PromptTemplateConfig promptTemplateConfig, @Nonnull List<Block> blocks) {
        this.promptTemplateConfig = promptTemplateConfig;
        this.blocks = Collections.unmodifiableList(blocks);
    }

    public static DefaultPromptTemplate build(@Nonnull PromptTemplateConfig promptTemplateConfig) {
        List<Block> blocks = DefaultPromptTemplate.extractBlocks(promptTemplateConfig);
        promptTemplateConfig = DefaultPromptTemplate.addMissingInputVariables(promptTemplateConfig, blocks);
        return new DefaultPromptTemplate(promptTemplateConfig, blocks);
    }

    private static List<Block> extractBlocks(PromptTemplateConfig promptTemplateConfig) {
        String templateText = promptTemplateConfig.getTemplate();
        if (templateText == null) {
            throw new SKException(String.format("No prompt template was provided for the prompt %s.", promptTemplateConfig.getName()));
        }
        List<Block> blocks = new TemplateTokenizer().tokenize(templateText);
        Optional<Block> invalid = blocks.stream().filter(block -> !block.isValid()).findFirst();
        if (invalid.isPresent()) {
            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Invalid block: " + invalid.get().getContent());
        }
        return blocks;
    }

    private static PromptTemplateConfig addMissingInputVariables(PromptTemplateConfig promptTemplateConfig, List<Block> blocks) {
        HashSet seen = new HashSet();
        seen.addAll(promptTemplateConfig.getInputVariables().stream().map(InputVariable::getName).collect(Collectors.toList()));
        PromptTemplateConfig.Builder promptTemplateConfigBuilder = promptTemplateConfig.copy();
        blocks.forEach(block -> {
            String name = null;
            if (block.getType() == BlockTypes.VARIABLE) {
                name = ((VarBlock)block).getName();
            } else if (block.getType() == BlockTypes.NAMED_ARG) {
                VarBlock blockName = ((NamedArgBlock)block).getVarBlock();
                String string = name = blockName == null ? null : blockName.getName();
            }
            if (!Verify.isNullOrEmpty(name) && !seen.contains(name)) {
                seen.add(name);
                promptTemplateConfigBuilder.addInputVariable(new InputVariable(name));
            }
        });
        return promptTemplateConfigBuilder.build();
    }

    @Override
    public Mono<String> renderAsync(Kernel kernel, @Nullable KernelFunctionArguments arguments, @Nullable InvocationContext context) {
        ContextVariableTypes types = context != null ? context.getContextVariableTypes() : new ContextVariableTypes();
        return Flux.fromIterable(this.blocks).concatMap(block -> {
            if (block instanceof TextRendering) {
                return Mono.just((Object)((TextRendering)((Object)block)).render(types, arguments));
            }
            if (block instanceof CodeRendering) {
                return ((CodeRendering)((Object)block)).renderCodeAsync(kernel, arguments, context);
            }
            return Mono.error((Throwable)new TemplateException(TemplateException.ErrorCodes.UNEXPECTED_BLOCK_TYPE));
        }).reduce((Object)"", (a, b) -> a + b);
    }
}

