/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.data.vectorstorage.VectorStoreRecordCollectionOptions;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordDefinition;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VolatileVectorStoreRecordCollectionOptions<Record>
implements VectorStoreRecordCollectionOptions<String, Record> {
    private final Class<Record> recordClass;
    @Nullable
    private final VectorStoreRecordDefinition recordDefinition;
    @Nullable
    private final ObjectMapper objectMapper;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public VolatileVectorStoreRecordCollectionOptions(@Nonnull Class<Record> recordClass, @Nullable VectorStoreRecordDefinition recordDefinition, ObjectMapper objectMapper) {
        this.recordClass = recordClass;
        this.recordDefinition = recordDefinition;
        this.objectMapper = objectMapper;
    }

    public static <Record> Builder<Record> builder() {
        return new Builder();
    }

    @Override
    public Class<String> getKeyClass() {
        return String.class;
    }

    @Override
    public Class<Record> getRecordClass() {
        return this.recordClass;
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public VectorStoreRecordDefinition getRecordDefinition() {
        return this.recordDefinition;
    }

    public static class Builder<Record> {
        @Nullable
        private Class<Record> recordClass;
        @Nullable
        private VectorStoreRecordDefinition recordDefinition;
        @Nullable
        private ObjectMapper objectMapper;

        public Builder<Record> withRecordClass(Class<Record> recordClass) {
            this.recordClass = recordClass;
            return this;
        }

        public Builder<Record> withRecordDefinition(VectorStoreRecordDefinition recordDefinition) {
            this.recordDefinition = recordDefinition;
            return this;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public Builder<Record> withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public VolatileVectorStoreRecordCollectionOptions<Record> build() {
            if (this.recordClass == null) {
                throw new IllegalArgumentException("recordClass is required");
            }
            return new VolatileVectorStoreRecordCollectionOptions<Record>(this.recordClass, this.recordDefinition, this.objectMapper);
        }
    }
}

