/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorstorage.definition;

import com.microsoft.semantickernel.data.vectorstorage.definition.DistanceFunction;
import com.microsoft.semantickernel.data.vectorstorage.definition.IndexKind;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordField;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorStoreRecordVectorField
extends VectorStoreRecordField {
    private final int dimensions;
    private final IndexKind indexKind;
    private final DistanceFunction distanceFunction;

    public static Builder builder() {
        return new Builder();
    }

    public VectorStoreRecordVectorField(@Nonnull String name, @Nullable String storageName, @Nonnull Class<?> fieldType, int dimensions, @Nullable IndexKind indexKind, @Nullable DistanceFunction distanceFunction) {
        super(name, storageName, fieldType);
        this.dimensions = dimensions;
        this.indexKind = indexKind == null ? IndexKind.UNDEFINED : indexKind;
        this.distanceFunction = distanceFunction == null ? DistanceFunction.UNDEFINED : distanceFunction;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public IndexKind getIndexKind() {
        return this.indexKind;
    }

    public DistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }

    public static class Builder
    extends VectorStoreRecordField.Builder<VectorStoreRecordVectorField, Builder> {
        private int dimensions;
        private IndexKind indexKind = IndexKind.UNDEFINED;
        private DistanceFunction distanceFunction = DistanceFunction.UNDEFINED;

        public Builder withDimensions(int dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder withIndexKind(IndexKind indexKind) {
            this.indexKind = indexKind;
            return this;
        }

        public Builder withDistanceFunction(DistanceFunction distanceFunction) {
            this.distanceFunction = distanceFunction;
            return this;
        }

        @Override
        public VectorStoreRecordVectorField build() {
            if (this.name == null) {
                throw new IllegalArgumentException("name is required");
            }
            if (this.fieldType == null) {
                throw new IllegalArgumentException("fieldType is required");
            }
            if (this.dimensions <= 0) {
                throw new IllegalArgumentException("dimensions must be greater than 0");
            }
            return new VectorStoreRecordVectorField(this.name, this.storageName, this.fieldType, this.dimensions, this.indexKind, this.distanceFunction);
        }
    }
}

