/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.hooks;

import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.microsoft.semantickernel.hooks.FunctionInvokedEvent;
import com.microsoft.semantickernel.hooks.FunctionInvokingEvent;
import com.microsoft.semantickernel.hooks.KernelHookEvent;
import com.microsoft.semantickernel.hooks.PostChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreToolCallEvent;
import com.microsoft.semantickernel.hooks.PromptRenderedEvent;
import com.microsoft.semantickernel.hooks.PromptRenderingEvent;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public interface KernelHook<T extends KernelHookEvent>
extends Predicate<KernelHookEvent>,
Function<T, T> {
    default public int getPriority() {
        return 50;
    }

    public static interface PostChatCompletionHook
    extends KernelHook<PostChatCompletionEvent> {
        @Override
        default public boolean test(KernelHookEvent arguments) {
            return PostChatCompletionEvent.class.isAssignableFrom(arguments.getClass());
        }
    }

    public static interface PreChatCompletionHook
    extends KernelHook<PreChatCompletionEvent> {
        public static ChatCompletionsOptions cloneOptionsWithMessages(ChatCompletionsOptions options, List<ChatRequestMessage> messages) {
            ChatCompletionsOptions newOptions = new ChatCompletionsOptions(messages).setPresencePenalty(options.getPresencePenalty()).setFrequencyPenalty(options.getFrequencyPenalty()).setLogitBias(options.getLogitBias()).setMaxTokens(options.getMaxTokens()).setModel(options.getModel()).setStop(options.getStop()).setTemperature(options.getTemperature()).setTools(options.getTools()).setTopP(options.getTopP()).setUser(options.getUser()).setDataSources(options.getDataSources()).setEnhancements(options.getEnhancements()).setFunctions(options.getFunctions()).setN(options.getN()).setResponseFormat(options.getResponseFormat()).setSeed(options.getSeed()).setStream(options.isStream());
            if (options.getToolChoice() != null) {
                newOptions.setToolChoice(options.getToolChoice());
            }
            if (options.getFunctionCall() != null) {
                newOptions = newOptions.setFunctionCall(options.getFunctionCall());
            }
            return newOptions;
        }

        @Override
        default public boolean test(KernelHookEvent arguments) {
            return PreChatCompletionEvent.class.isAssignableFrom(arguments.getClass());
        }
    }

    public static interface PromptRenderedHook
    extends KernelHook<PromptRenderedEvent> {
        @Override
        default public boolean test(KernelHookEvent arguments) {
            return PromptRenderedEvent.class.isAssignableFrom(arguments.getClass());
        }
    }

    public static interface PreToolCallHook
    extends KernelHook<PreToolCallEvent> {
        @Override
        default public boolean test(KernelHookEvent arguments) {
            return PreToolCallEvent.class.isAssignableFrom(arguments.getClass());
        }
    }

    public static interface PromptRenderingHook
    extends KernelHook<PromptRenderingEvent> {
        @Override
        default public boolean test(KernelHookEvent arguments) {
            return PromptRenderingEvent.class.isAssignableFrom(arguments.getClass());
        }
    }

    public static interface FunctionInvokedHook
    extends KernelHook<FunctionInvokedEvent<?>> {
        @Override
        default public boolean test(KernelHookEvent arguments) {
            return FunctionInvokedEvent.class.isAssignableFrom(arguments.getClass());
        }
    }

    public static interface FunctionInvokingHook
    extends KernelHook<FunctionInvokingEvent<?>> {
        @Override
        default public boolean test(KernelHookEvent arguments) {
            return FunctionInvokingEvent.class.isAssignableFrom(arguments.getClass());
        }
    }
}

