/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration.responseformat;

import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.ServiceLoadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ResponseSchemaGenerator {
    public static final Logger LOGGER = LoggerFactory.getLogger(ResponseSchemaGenerator.class);

    public String generateSchema(Class<?> var1);

    public static ResponseSchemaGenerator jacksonGenerator() {
        try {
            return ResponseSchemaGenerator.loadGenerator("com.microsoft.semantickernel.aiservices.openai.chatcompletion.responseformat.JacksonResponseFormatGenerator");
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("The Jackson response schema generator relies on the optional dependencies 'com.github.victools:jsonschema-generator', and 'com.github.victools:jsonschema-module-jackson'. To use this feature, please add this dependency to your project.");
            throw new SKException("The Jackson response schema generator relies on the optional dependency 'com.github.victools:jsonschema-generator', and 'com.github.victools:jsonschema-module-jackson'. To use this feature, please add this dependency to your project.");
        }
    }

    public static ResponseSchemaGenerator loadGenerator(String className) {
        return ServiceLoadUtil.findServiceLoader(ResponseSchemaGenerator.class, className).get();
    }
}

