/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.semantickernel.data.vectorsearch.VectorSearchResult;
import com.microsoft.semantickernel.data.vectorstorage.definition.DistanceFunction;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordVectorField;
import com.microsoft.semantickernel.data.vectorstorage.options.VectorSearchOptions;
import com.microsoft.semantickernel.exceptions.SKException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class VectorOperations {
    public static float cosineSimilarity(@Nonnull List<Float> x, @Nonnull List<Float> y) {
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        if (x.size() != y.size()) {
            throw new SKException("Vectors lengths must be equal");
        }
        float dotProduct = 0.0f;
        float normX = 0.0f;
        float normY = 0.0f;
        for (int i = 0; i < x.size(); ++i) {
            dotProduct += x.get(i).floatValue() * y.get(i).floatValue();
            normX += x.get(i).floatValue() * x.get(i).floatValue();
            normY += y.get(i).floatValue() * y.get(i).floatValue();
        }
        if (normX == 0.0f || normY == 0.0f) {
            throw new SKException("Vectors cannot have zero norm");
        }
        return dotProduct / (float)(Math.sqrt(normX) * Math.sqrt(normY));
    }

    public static double cosineDistance(List<Float> x, List<Float> y) {
        return 1.0 - (double)VectorOperations.cosineSimilarity(x, y);
    }

    public static float euclideanDistance(@Nonnull List<Float> x, @Nonnull List<Float> y) {
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        if (x.size() != y.size()) {
            throw new SKException("Vectors lengths must be equal");
        }
        float sumOfSquaredDifferences = 0.0f;
        for (int i = 0; i < x.size(); ++i) {
            float difference = x.get(i).floatValue() - y.get(i).floatValue();
            sumOfSquaredDifferences += difference * difference;
        }
        return (float)Math.sqrt(sumOfSquaredDifferences);
    }

    public static List<Float> divide(@Nonnull List<Float> vector, float divisor) {
        Objects.requireNonNull(vector);
        if (Float.isNaN(divisor)) {
            throw new SKException("Divisor cannot be NaN");
        }
        if (divisor == 0.0f) {
            throw new SKException("Divisor cannot be zero");
        }
        return vector.stream().map(x -> Float.valueOf(x.floatValue() / divisor)).collect(Collectors.toList());
    }

    public static float dot(@Nonnull List<Float> x, @Nonnull List<Float> y) {
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        if (x.size() != y.size()) {
            throw new SKException("Vectors lengths must be equal");
        }
        float result = 0.0f;
        for (int i = 0; i < x.size(); ++i) {
            result += x.get(i).floatValue() * y.get(i).floatValue();
        }
        return result;
    }

    public static float euclideanLength(@Nonnull List<Float> vector) {
        Objects.requireNonNull(vector);
        return (float)Math.sqrt(VectorOperations.dot(vector, vector));
    }

    public static List<Float> multiply(@Nonnull List<Float> vector, float multiplier) {
        Objects.requireNonNull(vector);
        if (Float.isNaN(multiplier)) {
            throw new SKException("Multiplier cannot be NaN");
        }
        if (Float.isInfinite(multiplier)) {
            throw new SKException("Multiplier cannot be infinite");
        }
        return vector.stream().map(x -> Float.valueOf(x.floatValue() * multiplier)).collect(Collectors.toList());
    }

    public static List<Float> normalize(@Nonnull List<Float> vector) {
        Objects.requireNonNull(vector);
        return VectorOperations.divide(vector, VectorOperations.euclideanLength(vector));
    }

    public static <Record> List<VectorSearchResult<Record>> exactSimilaritySearch(List<Record> records, List<Float> vector, VectorStoreRecordVectorField vectorField, DistanceFunction distanceFunction, VectorSearchOptions options) {
        ArrayList<VectorSearchResult<Record>> results = new ArrayList<VectorSearchResult<Record>>();
        for (Record record : records) {
            double score;
            List<Float> recordVector;
            try {
                String json = new ObjectMapper().writeValueAsString(record);
                ArrayNode arrayNode = (ArrayNode)new ObjectMapper().readTree(json).get(vectorField.getEffectiveStorageName());
                recordVector = Stream.iterate(0, i -> i + 1).limit(arrayNode.size()).map(i -> Float.valueOf(arrayNode.get(i.intValue()).floatValue())).collect(Collectors.toList());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            switch (distanceFunction) {
                case COSINE_SIMILARITY: {
                    score = VectorOperations.cosineSimilarity(vector, recordVector);
                    break;
                }
                case COSINE_DISTANCE: {
                    score = VectorOperations.cosineDistance(vector, recordVector);
                    break;
                }
                case EUCLIDEAN_DISTANCE: {
                    score = VectorOperations.euclideanDistance(vector, recordVector);
                    break;
                }
                case DOT_PRODUCT: {
                    score = VectorOperations.dot(vector, recordVector);
                    break;
                }
                default: {
                    throw new SKException("Unsupported distance function");
                }
            }
            results.add(new VectorSearchResult<Record>(record, score));
        }
        Comparator<VectorSearchResult> comparator = Comparator.comparingDouble(VectorSearchResult::getScore);
        if (distanceFunction == DistanceFunction.COSINE_SIMILARITY || distanceFunction == DistanceFunction.DOT_PRODUCT) {
            comparator = comparator.reversed();
        }
        return results.stream().sorted(comparator).skip(options.getSkip()).limit(options.getTop()).collect(Collectors.toList());
    }
}

