/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorstorage.definition;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorStoreRecordField {
    private final String name;
    @Nullable
    private final String storageName;
    private final Class<?> fieldType;

    public VectorStoreRecordField(@Nonnull String name, @Nullable String storageName, @Nonnull Class<?> fieldType) {
        this.name = name;
        this.storageName = storageName;
        this.fieldType = fieldType;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getEffectiveStorageName() {
        return this.storageName != null ? this.storageName : this.name;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public static abstract class Builder<T, U extends Builder<T, U>>
    implements SemanticKernelBuilder<T> {
        @Nullable
        protected String name;
        @Nullable
        protected String storageName;
        @Nullable
        protected Class<?> fieldType;

        public U withName(String name) {
            this.name = name;
            return (U)this;
        }

        public U withStorageName(String storageName) {
            this.storageName = storageName;
            return (U)this;
        }

        public U withFieldType(Class<?> fieldType) {
            this.fieldType = fieldType;
            return (U)this;
        }

        @Override
        public abstract T build();
    }
}

