/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.telemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.reactor.v3_1.ContextPropagationOperator;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public abstract class SemanticKernelTelemetrySpan
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticKernelTelemetrySpan.class);
    private static final long SPAN_TIMEOUT_MS = Long.parseLong((String)System.getProperties().getOrDefault((Object)"semantickernel.telemetry.span_timeout", "120000"));
    private final Span span;
    private final Function<reactor.util.context.Context, reactor.util.context.Context> reactorContextModifier;
    private final Scope spanScope;
    private final Scope contextScope;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Disposable watchdog;
    private final Object finalizerGuardian = new Object(){

        protected void finalize() {
            if (!SemanticKernelTelemetrySpan.this.closed.get()) {
                LOGGER.warn("Span was not closed");
                SemanticKernelTelemetrySpan.this.close();
            }
        }
    };

    public SemanticKernelTelemetrySpan(Span span, Function<reactor.util.context.Context, reactor.util.context.Context> reactorContextModifier, Scope spanScope, Scope contextScope) {
        this.span = span;
        this.reactorContextModifier = reactorContextModifier;
        this.spanScope = spanScope;
        this.contextScope = contextScope;
        Mono.just((Object)1);
        this.watchdog = Mono.delay((Duration)Duration.ofMillis(SPAN_TIMEOUT_MS)).subscribe(i -> {
            if (!this.closed.get()) {
                LOGGER.warn("Span was not closed, timing out");
                this.close();
            }
        });
    }

    public static <T extends SemanticKernelTelemetrySpan> T build(Span span, ContextView contextView, SpanConstructor<T> builder) {
        LOGGER.trace("Starting Span: {}", (Object)span);
        Context currentOtelContext = ContextPropagationOperator.getOpenTelemetryContextFromContextView((ContextView)contextView, (Context)Context.current());
        Context otelContext = span.storeInContext(currentOtelContext);
        Scope contextScope = otelContext.makeCurrent();
        Scope spanScope = span.makeCurrent();
        Function<reactor.util.context.Context, reactor.util.context.Context> reactorContextModifier = ctx -> ContextPropagationOperator.storeOpenTelemetryContext((reactor.util.context.Context)ctx, (Context)otelContext);
        return builder.build(reactorContextModifier, spanScope, contextScope);
    }

    public Function<reactor.util.context.Context, reactor.util.context.Context> getReactorContextModifier() {
        return this.reactorContextModifier;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            LOGGER.trace("Closing span: {}", (Object)this.span);
            if (this.span.isRecording()) {
                try {
                    this.span.end();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing span", (Throwable)e);
                }
            }
            if (this.contextScope != null) {
                try {
                    this.contextScope.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing context scope", (Throwable)e);
                }
            }
            if (this.spanScope != null) {
                try {
                    this.spanScope.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing span scope", (Throwable)e);
                }
            }
            this.watchdog.dispose();
        }
    }

    public Span getSpan() {
        return this.span;
    }

    public static interface SpanConstructor<T extends SemanticKernelTelemetrySpan> {
        public T build(Function<reactor.util.context.Context, reactor.util.context.Context> var1, Scope var2, Scope var3);
    }
}

