/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.implementation.telemetry.SemanticKernelTelemetry;
import com.microsoft.semantickernel.orchestration.InvocationReturnMode;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public class InvocationContext {
    @Nullable
    private final KernelHooks.UnmodifiableKernelHooks hooks;
    @Nullable
    private final PromptExecutionSettings promptExecutionSettings;
    @Nullable
    private final ToolCallBehavior toolCallBehavior;
    private final ContextVariableTypes contextVariableTypes;
    private final InvocationReturnMode invocationReturnMode;
    private final SemanticKernelTelemetry telemetry;

    protected InvocationContext(@Nullable KernelHooks hooks, @Nullable PromptExecutionSettings promptExecutionSettings, @Nullable ToolCallBehavior toolCallBehavior, @Nullable ContextVariableTypes contextVariableTypes, InvocationReturnMode invocationReturnMode, SemanticKernelTelemetry telemetry) {
        this.hooks = InvocationContext.unmodifiableClone(hooks);
        this.promptExecutionSettings = promptExecutionSettings;
        this.toolCallBehavior = toolCallBehavior;
        this.invocationReturnMode = invocationReturnMode;
        this.contextVariableTypes = contextVariableTypes == null ? new ContextVariableTypes() : new ContextVariableTypes(contextVariableTypes);
        this.telemetry = telemetry;
    }

    protected InvocationContext() {
        this.hooks = null;
        this.promptExecutionSettings = null;
        this.toolCallBehavior = null;
        this.contextVariableTypes = new ContextVariableTypes();
        this.invocationReturnMode = InvocationReturnMode.NEW_MESSAGES_ONLY;
        this.telemetry = null;
    }

    protected InvocationContext(@Nullable InvocationContext context) {
        if (context == null) {
            this.hooks = null;
            this.promptExecutionSettings = null;
            this.toolCallBehavior = null;
            this.contextVariableTypes = new ContextVariableTypes();
            this.invocationReturnMode = InvocationReturnMode.NEW_MESSAGES_ONLY;
            this.telemetry = null;
        } else {
            this.hooks = context.hooks;
            this.promptExecutionSettings = context.promptExecutionSettings;
            this.toolCallBehavior = context.toolCallBehavior;
            this.contextVariableTypes = context.contextVariableTypes;
            this.invocationReturnMode = context.invocationReturnMode;
            this.telemetry = context.telemetry;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    private static KernelHooks.UnmodifiableKernelHooks unmodifiableClone(@Nullable KernelHooks kernelHooks) {
        if (kernelHooks instanceof KernelHooks.UnmodifiableKernelHooks) {
            return (KernelHooks.UnmodifiableKernelHooks)kernelHooks;
        }
        if (kernelHooks != null) {
            return kernelHooks.unmodifiableClone();
        }
        return null;
    }

    public static Builder copy(InvocationContext context) {
        return new Builder().withKernelHooks(context.getKernelHooks()).withContextVariableConverter(context.contextVariableTypes).withPromptExecutionSettings(context.getPromptExecutionSettings()).withToolCallBehavior(context.getToolCallBehavior()).withTelemetry(context.getTelemetry());
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="returns UnmodifiableKernelHooks")
    public KernelHooks.UnmodifiableKernelHooks getKernelHooks() {
        return this.hooks;
    }

    @Nullable
    public PromptExecutionSettings getPromptExecutionSettings() {
        return this.promptExecutionSettings;
    }

    @Nullable
    public ToolCallBehavior getToolCallBehavior() {
        return this.toolCallBehavior;
    }

    public ContextVariableTypes getContextVariableTypes() {
        return new ContextVariableTypes(this.contextVariableTypes);
    }

    public InvocationReturnMode returnMode() {
        return this.invocationReturnMode;
    }

    public SemanticKernelTelemetry getTelemetry() {
        return this.telemetry;
    }

    public static class Builder
    implements SemanticKernelBuilder<InvocationContext> {
        private final ContextVariableTypes contextVariableTypes = new ContextVariableTypes();
        @Nullable
        private KernelHooks.UnmodifiableKernelHooks hooks;
        @Nullable
        private PromptExecutionSettings promptExecutionSettings;
        @Nullable
        private ToolCallBehavior toolCallBehavior;
        private InvocationReturnMode invocationReturnMode = InvocationReturnMode.NEW_MESSAGES_ONLY;
        @Nullable
        private SemanticKernelTelemetry telemetry;

        public Builder withKernelHooks(@Nullable KernelHooks hooks) {
            this.hooks = InvocationContext.unmodifiableClone(hooks);
            return this;
        }

        public Builder withPromptExecutionSettings(@Nullable PromptExecutionSettings promptExecutionSettings) {
            this.promptExecutionSettings = promptExecutionSettings;
            return this;
        }

        public Builder withToolCallBehavior(@Nullable ToolCallBehavior toolCallBehavior) {
            this.toolCallBehavior = toolCallBehavior;
            return this;
        }

        public Builder withContextVariableConverter(ContextVariableTypeConverter<?> converter) {
            this.contextVariableTypes.putConverter(converter);
            return this;
        }

        public Builder withContextVariableConverter(ContextVariableTypes contextVariableTypes) {
            this.contextVariableTypes.putConverters(contextVariableTypes);
            return this;
        }

        public Builder withReturnMode(InvocationReturnMode invocationReturnMode) {
            this.invocationReturnMode = invocationReturnMode;
            return this;
        }

        public Builder withTelemetry(@Nullable SemanticKernelTelemetry telemetry) {
            this.telemetry = telemetry;
            return this;
        }

        @Override
        public InvocationContext build() {
            if (this.telemetry == null) {
                this.telemetry = new SemanticKernelTelemetry();
            }
            return new InvocationContext(this.hooks, this.promptExecutionSettings, this.toolCallBehavior, this.contextVariableTypes, this.invocationReturnMode, this.telemetry);
        }
    }
}

