/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.chatcompletion.message;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.services.KernelContent;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import com.microsoft.semantickernel.services.chatcompletion.message.ChatMessageContentType;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;

public class ChatMessageTextContent
extends ChatMessageContent<String> {
    public ChatMessageTextContent(AuthorRole authorRole, String content, @Nullable String modelId, @Nullable Charset encoding, @Nullable FunctionResultMetadata metadata) {
        super(authorRole, content, modelId, null, encoding, metadata, ChatMessageContentType.TEXT);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ChatMessageTextContent buildContent(AuthorRole role, String content) {
        return new Builder().withAuthorRole(role).withContent(content).build();
    }

    public static ChatMessageTextContent userMessage(String content) {
        return ChatMessageTextContent.buildContent(AuthorRole.USER, content);
    }

    public static ChatMessageTextContent assistantMessage(String content) {
        return ChatMessageTextContent.buildContent(AuthorRole.ASSISTANT, content);
    }

    public static ChatMessageTextContent systemMessage(String content) {
        return ChatMessageTextContent.buildContent(AuthorRole.SYSTEM, content);
    }

    public static class Builder
    implements SemanticKernelBuilder<ChatMessageTextContent> {
        @Nullable
        private String modelId = null;
        @Nullable
        private FunctionResultMetadata metadata = null;
        @Nullable
        private AuthorRole authorRole = null;
        @Nullable
        private String content = null;
        @Nullable
        private List<KernelContent<String>> items = null;
        @Nullable
        private Charset encoding = null;

        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        public Builder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder withMetadata(FunctionResultMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withAuthorRole(AuthorRole authorRole) {
            this.authorRole = authorRole;
            return this;
        }

        public Builder withEncoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public ChatMessageTextContent build() {
            if (this.authorRole == null) {
                throw new SKException("Author role must be set");
            }
            if (this.content == null) {
                throw new SKException("Content must be set");
            }
            return new ChatMessageTextContent(this.authorRole, this.content, this.modelId, this.encoding, this.metadata);
        }
    }
}

