/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel;

import com.microsoft.semantickernel.KernelPluginCollection;
import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.orchestration.FunctionInvocation;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.plugin.KernelPlugin;
import com.microsoft.semantickernel.semanticfunctions.KernelArguments;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.services.AIServiceCollection;
import com.microsoft.semantickernel.services.AIServiceSelection;
import com.microsoft.semantickernel.services.AIServiceSelector;
import com.microsoft.semantickernel.services.OrderedAIServiceSelector;
import com.microsoft.semantickernel.services.ServiceNotFoundException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Kernel {
    private final AIServiceSelector serviceSelector;
    private final KernelPluginCollection plugins;
    private final KernelHooks globalKernelHooks;
    private final AIServiceCollection services;
    @Nullable
    private final Function<AIServiceCollection, AIServiceSelector> serviceSelectorProvider;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Kernel(AIServiceCollection services, @Nullable Function<AIServiceCollection, AIServiceSelector> serviceSelectorProvider, @Nullable List<KernelPlugin> plugins, @Nullable KernelHooks globalKernelHooks) {
        this.services = services;
        this.serviceSelectorProvider = serviceSelectorProvider;
        AIServiceSelector serviceSelector = serviceSelectorProvider == null ? new OrderedAIServiceSelector(services) : serviceSelectorProvider.apply(services);
        this.serviceSelector = serviceSelector;
        this.plugins = plugins != null ? new KernelPluginCollection(plugins) : new KernelPluginCollection();
        this.globalKernelHooks = new KernelHooks(globalKernelHooks);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(Kernel kernel) {
        return new Builder(kernel.services, kernel.serviceSelectorProvider, kernel.plugins);
    }

    public Builder toBuilder() {
        return new Builder(this.services, this.serviceSelectorProvider, this.plugins);
    }

    public <T> FunctionInvocation<T> invokeAsync(String pluginName, String functionName) {
        KernelFunction<T> function = this.getFunction(pluginName, functionName);
        return this.invokeAsync(function);
    }

    public <T> FunctionResult<T> invoke(String pluginName, String functionName) {
        return (FunctionResult)this.invokeAsync(pluginName, functionName).block();
    }

    public <T> FunctionInvocation<T> invokePromptAsync(@Nonnull String prompt) {
        return this.invokeAsync(KernelFunction.createFromPrompt(prompt).build());
    }

    public <T> FunctionInvocation<T> invokePromptAsync(@Nonnull String prompt, @Nonnull KernelArguments arguments) {
        KernelFunction function = KernelFunction.createFromPrompt(prompt).build();
        return function.invokeAsync(this).withArguments(arguments);
    }

    public <T> FunctionInvocation<T> invokePromptAsync(@Nonnull String prompt, @Nonnull KernelArguments arguments, @Nonnull InvocationContext invocationContext) {
        KernelFunction function = KernelFunction.createFromPrompt(prompt).build();
        return function.invokeAsync(this).withArguments(arguments).withInvocationContext(invocationContext);
    }

    public <T> FunctionInvocation<T> invokeAsync(KernelFunction<T> function) {
        return function.invokeAsync(this);
    }

    public <T> FunctionResult<T> invoke(KernelFunction<T> function) {
        return (FunctionResult)this.invokeAsync(function).block();
    }

    @Nullable
    public KernelPlugin getPlugin(String pluginName) {
        return this.plugins.getPlugin(pluginName);
    }

    public Collection<KernelPlugin> getPlugins() {
        return Collections.unmodifiableCollection(this.plugins.getPlugins());
    }

    public <T> KernelFunction<T> getFunction(String pluginName, String functionName) {
        return this.plugins.getFunction(pluginName, functionName);
    }

    public List<KernelFunction<?>> getFunctions() {
        return this.plugins.getFunctions();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KernelHooks getGlobalKernelHooks() {
        return this.globalKernelHooks;
    }

    public AIServiceSelector getServiceSelector() {
        return this.serviceSelector;
    }

    public <T extends AIService> T getService(Class<T> clazz) throws ServiceNotFoundException {
        AIServiceSelection<T> selector = this.serviceSelector.trySelectAIService(clazz, null);
        if (selector == null) {
            throw new ServiceNotFoundException("Unable to find service of type " + clazz.getName());
        }
        return selector.getService();
    }

    public <T extends AIService> T getService(Class<T> clazz, KernelArguments args) throws ServiceNotFoundException {
        AIServiceSelection<T> selector = this.serviceSelector.trySelectAIService(clazz, args);
        if (selector == null) {
            throw new ServiceNotFoundException("Unable to find service of type " + clazz.getName());
        }
        return selector.getService();
    }

    public static class Builder
    implements SemanticKernelBuilder<Kernel> {
        private final AIServiceCollection services = new AIServiceCollection();
        private final List<KernelPlugin> plugins = new ArrayList<KernelPlugin>();
        @Nullable
        private Function<AIServiceCollection, AIServiceSelector> serviceSelectorProvider;

        public Builder() {
        }

        private Builder(AIServiceCollection services, @Nullable Function<AIServiceCollection, AIServiceSelector> serviceSelectorProvider, KernelPluginCollection plugins) {
            this.services.putAll(services);
            this.serviceSelectorProvider = serviceSelectorProvider;
            this.plugins.addAll(plugins.getPlugins());
        }

        public <T extends AIService> Builder withAIService(Class<T> clazz, T aiService) {
            this.services.put(clazz, aiService);
            return this;
        }

        public Builder withPlugin(KernelPlugin plugin) {
            this.plugins.add(plugin);
            return this;
        }

        public Builder withServiceSelector(Function<AIServiceCollection, AIServiceSelector> serviceSelector) {
            this.serviceSelectorProvider = serviceSelector;
            return this;
        }

        @Override
        public Kernel build() {
            return new Kernel(this.services, this.serviceSelectorProvider, this.plugins, null);
        }
    }
}

