/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.agents;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.agents.Agent;
import com.microsoft.semantickernel.agents.AgentInvokeOptions;
import com.microsoft.semantickernel.agents.AgentResponseItem;
import com.microsoft.semantickernel.agents.AgentThread;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.semanticfunctions.KernelArguments;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KernelAgent
implements Agent {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final Kernel kernel;
    protected final KernelArguments kernelArguments;
    protected final InvocationContext invocationContext;
    protected final String instructions;
    protected final PromptTemplate template;

    protected KernelAgent(String id, String name, String description, Kernel kernel, KernelArguments kernelArguments, InvocationContext invocationContext, String instructions, PromptTemplate template) {
        this.id = id != null ? id : UUID.randomUUID().toString();
        this.name = name;
        this.description = description;
        this.kernel = kernel;
        this.kernelArguments = kernelArguments != null ? kernelArguments.copy() : KernelArguments.builder().build();
        this.invocationContext = invocationContext != null ? invocationContext : InvocationContext.builder().build();
        this.instructions = instructions;
        this.template = template;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KernelArguments getKernelArguments() {
        return this.kernelArguments;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public PromptTemplate getTemplate() {
        return this.template;
    }

    protected KernelArguments mergeArguments(KernelArguments arguments) {
        if (arguments == null) {
            return this.kernelArguments;
        }
        HashMap<String, PromptExecutionSettings> executionSettings = new HashMap<String, PromptExecutionSettings>(this.kernelArguments.getExecutionSettings());
        executionSettings.putAll(arguments.getExecutionSettings());
        return KernelArguments.builder().withVariables(this.kernelArguments).withVariables(arguments).withExecutionSettings(executionSettings).build();
    }

    protected Mono<String> renderInstructionsAsync(Kernel kernel, KernelArguments arguments, InvocationContext context) {
        if (this.template != null) {
            return this.template.renderAsync(kernel, arguments, context);
        }
        return Mono.just((Object)this.instructions);
    }

    protected <T extends AgentThread> Mono<T> ensureThreadExistsWithMessagesAsync(List<ChatMessageContent<?>> messages, AgentThread thread, Supplier<T> threadSupplier) {
        return Mono.defer(() -> {
            AgentThread newThread = thread == null ? (AgentThread)threadSupplier.get() : thread.copy();
            return newThread.createAsync().thenMany((Publisher)Flux.fromIterable((Iterable)messages)).concatMap(message -> this.notifyThreadOfNewMessageAsync(newThread, (ChatMessageContent<?>)message).then(Mono.just((Object)message))).then(Mono.just((Object)newThread));
        });
    }

    @Override
    public Mono<List<AgentResponseItem<ChatMessageContent<?>>>> invokeAsync(@Nullable ChatMessageContent<?> message) {
        return this.invokeAsync(message, null, null);
    }

    @Override
    public Mono<List<AgentResponseItem<ChatMessageContent<?>>>> invokeAsync(@Nullable ChatMessageContent<?> message, @Nullable AgentThread thread) {
        return this.invokeAsync(message, thread, null);
    }

    @Override
    public Mono<List<AgentResponseItem<ChatMessageContent<?>>>> invokeAsync(@Nullable ChatMessageContent<?> message, @Nullable AgentThread thread, @Nullable AgentInvokeOptions options) {
        ArrayList messages = new ArrayList();
        if (message != null) {
            messages.add(message);
        }
        return this.invokeAsync(messages, thread, options);
    }
}

