/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorsearch;

import com.microsoft.semantickernel.data.filter.AnyTagEqualToFilterClause;
import com.microsoft.semantickernel.data.filter.EqualToFilterClause;
import com.microsoft.semantickernel.data.filter.FilterClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VectorSearchFilter {
    private final List<FilterClause> filterClauses;

    public static VectorSearchFilter createDefault() {
        return new VectorSearchFilter();
    }

    public VectorSearchFilter() {
        this(Collections.emptyList());
    }

    public VectorSearchFilter(List<FilterClause> filterClauses) {
        this.filterClauses = Collections.unmodifiableList(filterClauses);
    }

    public List<FilterClause> getFilterClauses() {
        return this.filterClauses;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<FilterClause> filterClauses = new ArrayList<FilterClause>();

        public Builder equalTo(String fieldName, Object value) {
            this.filterClauses.add(new EqualToFilterClause(fieldName, value));
            return this;
        }

        public Builder anyTagEqualTo(String fieldName, Object value) {
            this.filterClauses.add(new AnyTagEqualToFilterClause(fieldName, value));
            return this;
        }

        public VectorSearchFilter build() {
            return new VectorSearchFilter(this.filterClauses);
        }
    }
}

