/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.functionchoice;

import com.microsoft.semantickernel.functionchoice.AutoFunctionChoiceBehavior;
import com.microsoft.semantickernel.functionchoice.FunctionChoiceBehaviorOptions;
import com.microsoft.semantickernel.functionchoice.NoneFunctionChoiceBehavior;
import com.microsoft.semantickernel.functionchoice.RequiredFunctionChoiceBehavior;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class FunctionChoiceBehavior {
    private final Set<String> fullFunctionNames;
    protected final List<KernelFunction<?>> functions;
    protected final FunctionChoiceBehaviorOptions options;
    public static final String FUNCTION_NAME_SEPARATOR = "-";

    protected FunctionChoiceBehavior(@Nullable List<KernelFunction<?>> functions, @Nullable FunctionChoiceBehaviorOptions options) {
        this.functions = functions != null ? Collections.unmodifiableList(functions) : null;
        this.fullFunctionNames = new HashSet<String>();
        if (functions != null) {
            functions.stream().filter(Objects::nonNull).forEach(f -> this.fullFunctionNames.add(FunctionChoiceBehavior.formFullFunctionName(f.getPluginName(), f.getName())));
        }
        this.options = options != null ? options : FunctionChoiceBehaviorOptions.builder().build();
    }

    public List<KernelFunction<?>> getFunctions() {
        return Collections.unmodifiableList(this.functions);
    }

    public FunctionChoiceBehaviorOptions getOptions() {
        return this.options;
    }

    public static FunctionChoiceBehavior auto(boolean autoInvoke) {
        return new AutoFunctionChoiceBehavior(autoInvoke, null, null);
    }

    public static FunctionChoiceBehavior auto(boolean autoInvoke, @Nullable List<KernelFunction<?>> functions) {
        return new AutoFunctionChoiceBehavior(autoInvoke, functions, null);
    }

    public static FunctionChoiceBehavior auto(boolean autoInvoke, @Nullable List<KernelFunction<?>> functions, @Nullable FunctionChoiceBehaviorOptions options) {
        return new AutoFunctionChoiceBehavior(autoInvoke, functions, options);
    }

    public static FunctionChoiceBehavior required(boolean autoInvoke, @Nullable List<KernelFunction<?>> functions) {
        return new RequiredFunctionChoiceBehavior(autoInvoke, functions, null);
    }

    public static FunctionChoiceBehavior required(boolean autoInvoke, @Nullable List<KernelFunction<?>> functions, @Nullable FunctionChoiceBehaviorOptions options) {
        return new RequiredFunctionChoiceBehavior(autoInvoke, functions, options);
    }

    public static FunctionChoiceBehavior none() {
        return new NoneFunctionChoiceBehavior(null, null);
    }

    public static FunctionChoiceBehavior none(@Nullable List<KernelFunction<?>> functions, @Nullable FunctionChoiceBehaviorOptions options) {
        return new NoneFunctionChoiceBehavior(functions, options);
    }

    public static String formFullFunctionName(@Nullable String pluginName, String functionName) {
        if (pluginName == null) {
            pluginName = "";
        }
        return String.format("%s%s%s", pluginName, FUNCTION_NAME_SEPARATOR, functionName);
    }

    public boolean isFunctionAllowed(KernelFunction<?> function) {
        return this.isFunctionAllowed(function.getPluginName(), function.getName());
    }

    public boolean isFunctionAllowed(@Nullable String pluginName, String functionName) {
        if (this.functions == null || this.functions.isEmpty()) {
            return true;
        }
        String key = FunctionChoiceBehavior.formFullFunctionName(pluginName, functionName);
        return this.fullFunctionNames.contains(key);
    }
}

