/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks;

import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.BlockTypes;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextRendering;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import com.microsoft.semantickernel.semanticfunctions.KernelArguments;
import com.microsoft.semantickernel.templateengine.semantickernel.TemplateException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarBlock
extends Block
implements TextRendering {
    private static final Logger LOGGER = LoggerFactory.getLogger(VarBlock.class);
    private final String name;

    public VarBlock(String content) {
        super(content, BlockTypes.VARIABLE);
        if (content.length() < 2) {
            LOGGER.error(SemanticKernelResources.getString("the.variable.name.is.empty"));
        }
        this.name = content.substring(1);
    }

    @Override
    public String render(ContextVariableTypes types, @Nullable KernelArguments variables) {
        if (variables == null) {
            return "";
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Variable rendering failed, the variable name is empty");
        }
        ContextVariable<?> value = variables.get(this.name);
        if (value == null) {
            LOGGER.warn(SemanticKernelResources.getString("variable.not.found"), (Object)Character.valueOf('$'), (Object)this.name);
        }
        return value != null ? value.toPromptString(types) : "";
    }

    @Override
    public boolean isValid() {
        if (this.getContent() == null || this.getContent().isEmpty()) {
            LOGGER.error(SemanticKernelResources.getString("a.variable.must.start.with.the.symbol.and.have.a.name"), (Object)Character.valueOf('$'));
            return false;
        }
        if (this.getContent().charAt(0) != '$') {
            LOGGER.error(SemanticKernelResources.getString("a.variable.must.start.with.the.symbol"), (Object)Character.valueOf('$'));
            return false;
        }
        if (this.getContent().length() < 2) {
            LOGGER.error(SemanticKernelResources.getString("the.variable.name.is.empty"));
            return false;
        }
        if (!this.name.matches("^[a-zA-Z0-9_]*$")) {
            LOGGER.error(SemanticKernelResources.getString("the.variable.name.contains.invalid.characters.only.alphanumeric.chars.and.underscore.are.allowed"), (Object)this.name);
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }
}

