/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.contextvariables.converters.ContextVariableJacksonConverter;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.functionchoice.FunctionChoiceBehavior;
import com.microsoft.semantickernel.hooks.KernelHook;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.implementation.telemetry.SemanticKernelTelemetry;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.InvocationReturnMode;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import com.microsoft.semantickernel.semanticfunctions.KernelArguments;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class FunctionInvocation<T>
extends Mono<FunctionResult<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionInvocation.class);
    protected final KernelFunction<?> function;
    protected final Kernel kernel;
    @Nullable
    protected final ContextVariableType<T> resultType;
    protected final ContextVariableTypes contextVariableTypes = new ContextVariableTypes();
    @Nullable
    protected KernelArguments arguments;
    @Nullable
    protected KernelHooks.UnmodifiableKernelHooks hooks;
    @Nullable
    protected PromptExecutionSettings promptExecutionSettings;
    @Nullable
    protected ToolCallBehavior toolCallBehavior;
    @Nullable
    protected FunctionChoiceBehavior functionChoiceBehavior;
    @Nullable
    protected SemanticKernelTelemetry telemetry;
    private boolean isSubscribed = false;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public FunctionInvocation(Kernel kernel, KernelFunction<T> function) {
        this.function = function;
        this.kernel = kernel;
        this.resultType = null;
        this.addKernelHooks(kernel.getGlobalKernelHooks());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public FunctionInvocation(Kernel kernel, KernelFunction<?> function, @Nullable ContextVariableType<T> resultType) {
        this.function = function;
        this.kernel = kernel;
        this.resultType = resultType;
        if (resultType != null) {
            this.contextVariableTypes.putConverter(resultType.getConverter());
        }
        this.addKernelHooks(kernel.getGlobalKernelHooks());
    }

    private static <T> void performSubscribe(CoreSubscriber<? super FunctionResult<T>> coreSubscriber, Kernel kernel, KernelFunction<?> function, @Nullable KernelArguments arguments, @Nullable ContextVariableType<T> variableType, @Nullable InvocationContext context) {
        if (variableType == null) {
            LOGGER.debug(SemanticKernelResources.getString("no.variable.type.explicitly.specified.by.calling.withresulttype.for.function"), (Object)function.getPluginName(), (Object)function.getName());
        }
        InvocationContext contextClone = new InvocationContext(context);
        function.invokeAsync(kernel, (KernelArguments)KernelArguments.builder().withVariables(arguments).build(), null, contextClone).handle(FunctionInvocation.convertToType(variableType, contextClone.getContextVariableTypes())).onErrorResume(e -> {
            if (e instanceof NoSuchElementException) {
                return Mono.empty();
            }
            return Mono.error((Throwable)e);
        }).subscribe(coreSubscriber);
    }

    private static <T> BiConsumer<FunctionResult<?>, SynchronousSink<FunctionResult<T>>> convertToType(@Nullable ContextVariableType<T> variableType, @Nullable ContextVariableTypes contextVariableTypes) {
        return (result, sink) -> {
            if (variableType != null) {
                try {
                    ContextVariableTypes types = new ContextVariableTypes(contextVariableTypes);
                    types.putConverter(variableType.getConverter());
                    sink.next(new FunctionResult(ContextVariable.convert(result.getResult(), variableType.getClazz(), types), result.getMetadata(), result.getUnconvertedResult()));
                }
                catch (Exception e) {
                    sink.error((Throwable)new SKException("Failed to convert result to requested type: " + variableType.getClazz().getName() + " " + result.getResult(), e));
                }
            } else {
                sink.next(result);
            }
        };
    }

    @Nullable
    private static KernelHooks.UnmodifiableKernelHooks unmodifiableClone(@Nullable KernelHooks kernelHooks) {
        if (kernelHooks instanceof KernelHooks.UnmodifiableKernelHooks) {
            return (KernelHooks.UnmodifiableKernelHooks)kernelHooks;
        }
        if (kernelHooks != null) {
            return kernelHooks.unmodifiableClone();
        }
        return null;
    }

    public FunctionInvocation<T> withArguments(@Nullable KernelArguments arguments) {
        this.logSubscribeWarning();
        this.arguments = KernelArguments.builder().withVariables(arguments).build();
        return this;
    }

    public <U> FunctionInvocation<U> withResultType(ContextVariableType<U> resultType) {
        this.logSubscribeWarning();
        return new FunctionInvocation<U>(this.kernel, this.function, resultType).withArguments(this.arguments).addKernelHooks(this.hooks).withPromptExecutionSettings(this.promptExecutionSettings).withFunctionChoiceBehavior(this.functionChoiceBehavior).withToolCallBehavior(this.toolCallBehavior).withTypes(this.contextVariableTypes);
    }

    public <U> FunctionInvocation<U> withResultTypeAutoConversion(Class<U> resultType) {
        try {
            return this.withTypeConverter(ContextVariableJacksonConverter.create(resultType)).withResultType(this.contextVariableTypes.getVariableTypeForSuperClass(resultType));
        }
        catch (SKException e) {
            return this.withResultType(ContextVariableTypes.getGlobalVariableTypeForClass(resultType));
        }
    }

    public <U> FunctionInvocation<U> withResultType(Class<U> resultType) {
        try {
            return this.withResultType(this.contextVariableTypes.getVariableTypeForSuperClass(resultType));
        }
        catch (SKException e) {
            return this.withResultType(ContextVariableTypes.getGlobalVariableTypeForClass(resultType));
        }
    }

    public FunctionInvocation<T> addKernelHook(@Nullable KernelHook<?> hook) {
        if (hook == null) {
            return this;
        }
        this.logSubscribeWarning();
        KernelHooks clone = new KernelHooks(this.hooks);
        clone.addHook(hook);
        this.hooks = FunctionInvocation.unmodifiableClone(clone);
        return this;
    }

    public FunctionInvocation<T> addKernelHooks(@Nullable KernelHooks hooks) {
        if (hooks == null) {
            return this;
        }
        this.logSubscribeWarning();
        this.hooks = FunctionInvocation.unmodifiableClone(new KernelHooks(this.hooks).addHooks(hooks));
        return this;
    }

    public FunctionInvocation<T> withPromptExecutionSettings(@Nullable PromptExecutionSettings promptExecutionSettings) {
        this.logSubscribeWarning();
        this.promptExecutionSettings = promptExecutionSettings;
        return this;
    }

    public FunctionInvocation<T> withToolCallBehavior(@Nullable ToolCallBehavior toolCallBehavior) {
        this.logSubscribeWarning();
        if (toolCallBehavior != null && this.functionChoiceBehavior != null) {
            throw new SKException("ToolCallBehavior cannot be set when FunctionChoiceBehavior is set.");
        }
        this.toolCallBehavior = toolCallBehavior;
        return this;
    }

    public FunctionInvocation<T> withFunctionChoiceBehavior(@Nullable FunctionChoiceBehavior functionChoiceBehavior) {
        if (functionChoiceBehavior != null && this.toolCallBehavior != null) {
            throw new SKException("FunctionChoiceBehavior cannot be set when ToolCallBehavior is set.");
        }
        this.logSubscribeWarning();
        this.functionChoiceBehavior = functionChoiceBehavior;
        return this;
    }

    public FunctionInvocation<T> withTypeConverter(ContextVariableTypeConverter<?> typeConverter) {
        this.logSubscribeWarning();
        this.contextVariableTypes.putConverter(typeConverter);
        return this;
    }

    public FunctionInvocation<T> withTypes(ContextVariableTypes contextVariableTypes) {
        this.logSubscribeWarning();
        this.contextVariableTypes.putConverters(contextVariableTypes);
        return this;
    }

    public FunctionInvocation<T> withTelemetry(SemanticKernelTelemetry telemetry) {
        this.telemetry = telemetry;
        return this;
    }

    public FunctionInvocation<T> withInvocationContext(@Nullable InvocationContext invocationContext) {
        if (invocationContext == null) {
            return this;
        }
        this.logSubscribeWarning();
        this.withTypes(invocationContext.getContextVariableTypes());
        this.withFunctionChoiceBehavior(invocationContext.getFunctionChoiceBehavior());
        this.withToolCallBehavior(invocationContext.getToolCallBehavior());
        this.withPromptExecutionSettings(invocationContext.getPromptExecutionSettings());
        this.addKernelHooks(invocationContext.getKernelHooks());
        this.withTelemetry(invocationContext.getTelemetry());
        return this;
    }

    private void logSubscribeWarning() {
        if (this.isSubscribed) {
            LOGGER.warn(SemanticKernelResources.getString("attempting.to.modify.function.after.it.has.already.been.subscribed"), (Object)this.function.getPluginName(), (Object)this.function.getName());
        }
    }

    public void subscribe(CoreSubscriber<? super FunctionResult<T>> coreSubscriber) {
        if (this.isSubscribed) {
            LOGGER.warn(SemanticKernelResources.getString("function.has.already.been.subscribed.to.this.is.not.necessarily.an.error.but.may.be.an.unusual.pattern"), (Object)this.function.getPluginName(), (Object)this.function.getName());
        }
        if (this.telemetry == null) {
            this.telemetry = new SemanticKernelTelemetry();
        }
        this.isSubscribed = true;
        FunctionInvocation.performSubscribe(coreSubscriber, this.kernel, this.function, this.arguments, this.resultType, new InvocationContext(this.hooks, this.promptExecutionSettings, this.toolCallBehavior, this.functionChoiceBehavior, this.contextVariableTypes, InvocationReturnMode.NEW_MESSAGES_ONLY, this.telemetry));
    }
}

