/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.contextvariables.CaseInsensitiveMap;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.util.annotation.NonNull;

public class KernelArguments
implements Map<String, ContextVariable<?>> {
    public static final String MAIN_KEY = "input";
    protected final CaseInsensitiveMap<ContextVariable<?>> variables;
    protected final Map<String, PromptExecutionSettings> executionSettings;

    protected KernelArguments(@Nullable Map<String, ContextVariable<?>> variables, @Nullable Map<String, PromptExecutionSettings> executionSettings) {
        this.variables = variables == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(variables);
        this.executionSettings = executionSettings == null ? new HashMap<String, PromptExecutionSettings>() : new HashMap<String, PromptExecutionSettings>(executionSettings);
    }

    protected KernelArguments(@NonNull ContextVariable<?> content) {
        this();
        this.variables.put(MAIN_KEY, content);
    }

    protected KernelArguments() {
        this.variables = new CaseInsensitiveMap();
        this.executionSettings = new HashMap<String, PromptExecutionSettings>();
    }

    protected KernelArguments(@NonNull KernelArguments arguments) {
        this.variables = new CaseInsensitiveMap(arguments.variables);
        this.executionSettings = new HashMap<String, PromptExecutionSettings>(arguments.executionSettings);
    }

    @Nonnull
    public Map<String, PromptExecutionSettings> getExecutionSettings() {
        return Collections.unmodifiableMap(this.executionSettings);
    }

    @Nullable
    public ContextVariable<?> getInput() {
        return this.get(MAIN_KEY);
    }

    public String prettyPrint() {
        return this.variables.entrySet().stream().reduce("", (str, entry) -> str + System.lineSeparator() + (String)entry.getKey() + ": " + ((ContextVariable)entry.getValue()).toPromptString(ContextVariableTypes.getGlobalTypes()), (a, b) -> a + b);
    }

    @Nullable
    public ContextVariable<?> get(String key) {
        return this.variables.get(key);
    }

    @Nullable
    <T> ContextVariable<T> get(String key, Class<T> clazz) {
        ContextVariable<?> value = this.variables.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getType().getClazz())) {
            return value;
        }
        throw new SKException(String.format("Variable %s is of type %s, but requested type is %s", key, value.getType().getClazz(), clazz));
    }

    public boolean isNullOrEmpty(String key) {
        return this.get(key) == null || this.get(key).isEmpty();
    }

    @Override
    public int size() {
        return this.variables.size();
    }

    @Override
    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.variables.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.variables.containsValue(value);
    }

    @Override
    @Nullable
    public ContextVariable<?> get(Object key) {
        return this.variables.get(key);
    }

    @Override
    public ContextVariable<?> put(String key, ContextVariable<?> value) {
        return this.variables.put(key, value);
    }

    @Override
    public ContextVariable<?> remove(Object key) {
        return this.variables.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends ContextVariable<?>> m) {
        this.variables.putAll((Map<String, ContextVariable<?>>)m);
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.variables.keySet();
    }

    @Override
    public Collection<ContextVariable<?>> values() {
        return this.variables.values();
    }

    @Override
    public Set<Map.Entry<String, ContextVariable<?>>> entrySet() {
        return this.variables.entrySet();
    }

    public KernelArguments copy() {
        return new KernelArguments(this.variables, this.executionSettings);
    }

    public static Builder<?> builder() {
        return new Builder<KernelArguments>(KernelArguments::new);
    }

    public static class Builder<U extends KernelArguments>
    implements SemanticKernelBuilder<U> {
        private final Function<KernelArguments, U> constructor;
        private final Map<String, ContextVariable<?>> variables;
        private final Map<String, PromptExecutionSettings> executionSettings;

        protected Builder(Function<KernelArguments, U> constructor) {
            this.constructor = constructor;
            this.variables = new HashMap();
            this.executionSettings = new HashMap<String, PromptExecutionSettings>();
        }

        public <T> Builder<U> withInput(ContextVariable<T> content) {
            return this.withVariable(KernelArguments.MAIN_KEY, content);
        }

        public Builder<U> withInput(Object content) {
            return this.withInput(ContextVariable.ofGlobalType(content));
        }

        public <T> Builder<U> withInput(T content, ContextVariableTypeConverter<T> typeConverter) {
            return this.withInput(new ContextVariable<T>(new ContextVariableType<T>(typeConverter, typeConverter.getType()), content));
        }

        public Builder<U> withVariables(@Nullable Map<String, ContextVariable<?>> map) {
            if (map == null) {
                return this;
            }
            this.variables.putAll(map);
            return this;
        }

        public <T> Builder<U> withVariable(String key, ContextVariable<T> value) {
            this.variables.put(key, value);
            return this;
        }

        public Builder<U> withVariable(String key, Object value) {
            if (value instanceof ContextVariable) {
                return this.withVariable(key, (ContextVariable)value);
            }
            return this.withVariable(key, ContextVariable.ofGlobalType(value));
        }

        public <T> Builder<U> withVariable(String key, T value, ContextVariableTypeConverter<T> typeConverter) {
            return this.withVariable(key, new ContextVariable<T>(new ContextVariableType<T>(typeConverter, typeConverter.getType()), value));
        }

        public Builder<U> withExecutionSettings(PromptExecutionSettings executionSettings) {
            return this.withExecutionSettings(Collections.singletonList(executionSettings));
        }

        public Builder<U> withExecutionSettings(Map<String, PromptExecutionSettings> executionSettings) {
            if (executionSettings == null) {
                return this;
            }
            this.executionSettings.putAll(executionSettings);
            return this;
        }

        public Builder<U> withExecutionSettings(List<PromptExecutionSettings> executionSettings) {
            if (executionSettings == null) {
                return this;
            }
            for (PromptExecutionSettings settings : executionSettings) {
                String serviceId = settings.getServiceId();
                if (this.executionSettings.containsKey(serviceId)) {
                    if (serviceId.equals("default")) {
                        throw new SKException(String.format("Multiple prompt execution settings with the default service id '%s' or no service id have been provided. Specify a single default prompt execution settings and provide a unique service id for all other instances.", "default"));
                    }
                    throw new SKException(String.format("Multiple prompt execution settings with the service id '%s' have been provided. Specify a unique service id for all instances.", serviceId));
                }
                this.executionSettings.put(serviceId, settings);
            }
            return this;
        }

        @Override
        public U build() {
            KernelArguments arguments = new KernelArguments(this.variables, this.executionSettings);
            return (U)((KernelArguments)this.constructor.apply(arguments));
        }
    }
}

