/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.azure.core.exception.HttpResponseException;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.hooks.FunctionInvokedEvent;
import com.microsoft.semantickernel.hooks.FunctionInvokingEvent;
import com.microsoft.semantickernel.hooks.KernelHooks;
import com.microsoft.semantickernel.hooks.PromptRenderedEvent;
import com.microsoft.semantickernel.hooks.PromptRenderingEvent;
import com.microsoft.semantickernel.implementation.telemetry.FunctionSpan;
import com.microsoft.semantickernel.implementation.telemetry.SemanticKernelTelemetry;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.KernelArguments;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionMetadata;
import com.microsoft.semantickernel.semanticfunctions.KernelPromptTemplateFactory;
import com.microsoft.semantickernel.semanticfunctions.OutputVariable;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateFactory;
import com.microsoft.semantickernel.services.AIServiceSelection;
import com.microsoft.semantickernel.services.TextAIService;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatCompletionService;
import com.microsoft.semantickernel.services.textcompletion.TextGenerationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class KernelFunctionFromPrompt<T>
extends KernelFunction<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KernelFunctionFromPrompt.class);
    private final PromptTemplate template;

    protected KernelFunctionFromPrompt(PromptTemplate template, PromptTemplateConfig promptConfig, @Nullable Map<String, PromptExecutionSettings> executionSettings) {
        super(new KernelFunctionMetadata(null, KernelFunctionFromPrompt.getName(promptConfig), promptConfig.getDescription(), promptConfig.getKernelParametersMetadata(), promptConfig.getKernelReturnParameterMetadata()), executionSettings != null ? executionSettings : promptConfig.getExecutionSettings());
        this.template = template;
    }

    private static String getName(PromptTemplateConfig promptConfig) {
        if (promptConfig.getName() == null) {
            return UUID.randomUUID().toString();
        }
        return promptConfig.getName();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Class<T> returnType) {
        return new Builder();
    }

    private Flux<FunctionResult<T>> invokeInternalAsync(Kernel kernel, @Nullable KernelArguments argumentsIn, @Nullable ContextVariableType<T> contextVariableType, @Nullable InvocationContext invocationContext) {
        InvocationContext context = invocationContext != null ? invocationContext : InvocationContext.builder().build();
        KernelHooks kernelHooks = KernelHooks.merge(kernel.getGlobalKernelHooks(), context.getKernelHooks());
        PromptRenderingEvent preRenderingHookResult = kernelHooks.executeHooks(new PromptRenderingEvent(this, argumentsIn));
        KernelArguments arguments = preRenderingHookResult.getArguments();
        ContextVariableType variableType = contextVariableType != null ? contextVariableType : context.getContextVariableTypes().getVariableTypeForClass(this.getMetadata().getOutputVariableType().getType());
        return this.template.renderAsync(kernel, arguments, context).flatMapMany(prompt -> {
            Flux result;
            TextAIService client;
            PromptRenderedEvent promptHookResult = kernelHooks.executeHooks(new PromptRenderedEvent(this, arguments, (String)prompt));
            prompt = promptHookResult.getPrompt();
            Object args = promptHookResult.getArguments();
            LOGGER.info(SemanticKernelResources.getString("rendered.prompt"), prompt);
            FunctionInvokingEvent invokingEvent = kernelHooks.executeHooks(new FunctionInvokingEvent(this, (KernelArguments)args));
            args = KernelArguments.builder().withVariables(invokingEvent.getArguments()).withExecutionSettings(this.getExecutionSettings()).build();
            AIServiceSelection<TextAIService> aiServiceSelection = kernel.getServiceSelector().trySelectAIService(TextAIService.class, this, (KernelArguments)args);
            TextAIService textAIService = client = aiServiceSelection != null ? aiServiceSelection.getService() : null;
            if (aiServiceSelection == null) {
                throw new IllegalStateException("Failed to initialise aiService, could not find any TextAIService implementations");
            }
            PromptExecutionSettings executionSettings = aiServiceSelection.getSettings();
            if (client instanceof ChatCompletionService) {
                InvocationContext contextWithExecutionSettings = context;
                if (context.getPromptExecutionSettings() == null) {
                    contextWithExecutionSettings = InvocationContext.copy(context).withPromptExecutionSettings(executionSettings).build();
                }
                result = ((ChatCompletionService)client).getChatMessageContentsAsync((String)prompt, kernel, contextWithExecutionSettings).flatMapMany(Flux::fromIterable).concatMap(chatMessageContent -> {
                    if (chatMessageContent.getAuthorRole() == AuthorRole.ASSISTANT) {
                        Object value = variableType.getConverter().fromObject(chatMessageContent);
                        if (value == null) {
                            value = variableType.getConverter().fromPromptString(chatMessageContent.getContent());
                        }
                        if (value == null) {
                            return Flux.empty();
                        }
                        return Flux.just(new FunctionResult(new ContextVariable(variableType, value), chatMessageContent.getMetadata(), chatMessageContent));
                    }
                    return Flux.empty();
                }).map(it -> new FunctionResult<Object>(new ContextVariable<Object>(variableType, (it.getResult() != null ? (Object)variableType.of(it.getResult()).getValue() : null)), it.getMetadata(), it.getUnconvertedResult()));
            } else if (client instanceof TextGenerationService) {
                result = ((TextGenerationService)client).getTextContentsAsync((String)prompt, executionSettings, kernel).flatMapMany(Flux::fromIterable).concatMap(textContent -> {
                    Object value = variableType.getConverter().fromObject(textContent);
                    if (value == null) {
                        value = variableType.getConverter().fromPromptString(textContent.getContent());
                    }
                    return Flux.just(new FunctionResult(new ContextVariable(variableType, value), textContent.getMetadata(), textContent));
                });
            } else {
                return Flux.error((Throwable)new IllegalStateException("Unknown service type"));
            }
            return result.map(it -> {
                FunctionInvokedEvent updatedResult = kernelHooks.executeHooks(new FunctionInvokedEvent(this, arguments, it));
                return updatedResult.getResult();
            });
        }).doOnError(ex -> {
            LOGGER.warn(SemanticKernelResources.getString("something.went.wrong.while.rendering.the.semantic.function.or.while.executing.the.text.completion.function.error"), new Object[]{this.getPluginName(), this.getName(), ex.getMessage()});
            if (ex instanceof HttpResponseException && ((HttpResponseException)ex).getResponse().getStatusCode() == 400 && ex.getMessage() != null && ex.getMessage().contains("parameters are not available on")) {
                LOGGER.warn(SemanticKernelResources.getString("this.error.indicates.that.you.have.attempted.to.use.a.chat.completion.model"));
            }
        });
    }

    @Override
    public Mono<FunctionResult<T>> invokeAsync(Kernel kernel, @Nullable KernelArguments arguments, @Nullable ContextVariableType<T> variableType, @Nullable InvocationContext invocationContext) {
        return Mono.deferContextual(contextView -> {
            FunctionSpan span = FunctionSpan.build(SemanticKernelTelemetry.getTelemetry(invocationContext), contextView, this.getPluginName(), this.getName(), arguments);
            return this.invokeInternalAsync(kernel, arguments, variableType, invocationContext).contextWrite(span.getReactorContextModifier()).takeLast(1).single().doOnSuccess(span::onFunctionSuccess).doOnError(span::onFunctionError).doOnTerminate(span::close);
        });
    }

    public static final class Builder<T>
    implements KernelFunction.FromPromptBuilder<T> {
        @Nullable
        private PromptTemplate promptTemplate;
        @Nullable
        private String name;
        @Nullable
        private Map<String, PromptExecutionSettings> executionSettings = null;
        @Nullable
        private String description;
        @Nullable
        private List<InputVariable> inputVariables;
        @Nullable
        private String template;
        private String templateFormat = "semantic-kernel";
        @Nullable
        private OutputVariable<?> outputVariable;
        @Nullable
        private PromptTemplateFactory promptTemplateFactory;
        @Nullable
        private PromptTemplateConfig promptTemplateConfig;

        @Override
        public KernelFunction.FromPromptBuilder<T> withName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withInputParameters(@Nullable List<InputVariable> inputVariables) {
            this.inputVariables = inputVariables != null ? new ArrayList<InputVariable>(inputVariables) : null;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withPromptTemplate(@Nullable PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withExecutionSettings(@Nullable Map<String, PromptExecutionSettings> executionSettings) {
            if (this.executionSettings == null) {
                this.executionSettings = new HashMap<String, PromptExecutionSettings>();
            }
            if (executionSettings != null) {
                this.executionSettings.putAll(executionSettings);
            }
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withDefaultExecutionSettings(@Nullable PromptExecutionSettings executionSettings) {
            if (executionSettings == null) {
                return this;
            }
            if (this.executionSettings == null) {
                this.executionSettings = new HashMap<String, PromptExecutionSettings>();
            }
            this.executionSettings.put("default", executionSettings);
            if (executionSettings.getServiceId() != null) {
                this.executionSettings.put(executionSettings.getServiceId(), executionSettings);
            }
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withTemplate(@Nullable String template) {
            this.template = template;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withTemplateFormat(String templateFormat) {
            this.templateFormat = templateFormat;
            return this;
        }

        @Override
        public <U> KernelFunction.FromPromptBuilder<U> withOutputVariable(@Nullable OutputVariable<U> outputVariable) {
            this.outputVariable = outputVariable;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withOutputVariable(@Nullable String description, String type) {
            return this.withOutputVariable(new OutputVariable(type, description));
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withPromptTemplateFactory(@Nullable PromptTemplateFactory promptTemplateFactory) {
            this.promptTemplateFactory = promptTemplateFactory;
            return this;
        }

        @Override
        public KernelFunction.FromPromptBuilder<T> withPromptTemplateConfig(@Nullable PromptTemplateConfig promptTemplateConfig) {
            this.promptTemplateConfig = promptTemplateConfig;
            return this;
        }

        @Override
        public KernelFunction<T> build() {
            if (this.templateFormat == null) {
                this.templateFormat = "semantic-kernel";
            }
            if (this.name == null) {
                this.name = UUID.randomUUID().toString();
            }
            if (this.promptTemplateFactory == null) {
                this.promptTemplateFactory = new KernelPromptTemplateFactory();
            }
            if (this.promptTemplateConfig != null) {
                if (this.promptTemplate == null) {
                    this.promptTemplate = this.promptTemplateFactory.tryCreate(this.promptTemplateConfig);
                }
                return new KernelFunctionFromPrompt(this.promptTemplate, this.promptTemplateConfig, this.executionSettings);
            }
            PromptTemplateConfig config = new PromptTemplateConfig(this.name, this.template, this.templateFormat, Collections.emptySet(), this.description, this.inputVariables, this.outputVariable, this.executionSettings);
            PromptTemplate temp = this.promptTemplate != null ? this.promptTemplate : new KernelPromptTemplateFactory().tryCreate(config);
            return new KernelFunctionFromPrompt(temp, config, this.executionSettings);
        }
    }
}

