/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.chatcompletion;

import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import com.microsoft.semantickernel.services.chatcompletion.ChatMessageContent;
import com.microsoft.semantickernel.services.chatcompletion.message.ChatMessageTextContent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ChatHistory
implements Iterable<ChatMessageContent<?>> {
    private final List<ChatMessageContent<?>> chatMessageContents;

    public ChatHistory() {
        this((String)null);
    }

    public ChatHistory(@Nullable String instructions) {
        this.chatMessageContents = Collections.synchronizedList(new ArrayList());
        if (instructions != null) {
            this.chatMessageContents.add(ChatMessageTextContent.systemMessage(instructions));
        }
    }

    public ChatHistory(List<? extends ChatMessageContent<?>> chatMessageContents) {
        this.chatMessageContents = Collections.synchronizedList(new ArrayList(chatMessageContents));
    }

    public List<ChatMessageContent<?>> getMessages() {
        return Collections.unmodifiableList(new ArrayList(this.chatMessageContents));
    }

    public Optional<ChatMessageContent<?>> getLastMessage() {
        if (this.chatMessageContents.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.chatMessageContents.get(this.chatMessageContents.size() - 1));
    }

    public void addAll(ChatHistory value) {
        this.chatMessageContents.addAll(value.getMessages());
    }

    @Override
    public Iterator<ChatMessageContent<?>> iterator() {
        return this.chatMessageContents.iterator();
    }

    @Override
    public void forEach(Consumer<? super ChatMessageContent<?>> action) {
        this.chatMessageContents.forEach(action);
    }

    @Override
    public Spliterator<ChatMessageContent<?>> spliterator() {
        return this.chatMessageContents.spliterator();
    }

    public ChatHistory addMessage(AuthorRole authorRole, String content, Charset encoding, FunctionResultMetadata<?> metadata) {
        this.chatMessageContents.add(ChatMessageTextContent.builder().withAuthorRole(authorRole).withContent(content).withEncoding(encoding).withMetadata(metadata).build());
        return this;
    }

    public ChatHistory addMessage(AuthorRole authorRole, String content) {
        this.chatMessageContents.add(ChatMessageTextContent.builder().withAuthorRole(authorRole).withContent(content).build());
        return this;
    }

    public ChatHistory addMessage(ChatMessageContent<?> content) {
        this.chatMessageContents.add(content);
        return this;
    }

    public ChatHistory addUserMessage(String content) {
        return this.addMessage(AuthorRole.USER, content);
    }

    public ChatHistory addAssistantMessage(String content) {
        return this.addMessage(AuthorRole.ASSISTANT, content);
    }

    public ChatHistory addSystemMessage(String content) {
        return this.addMessage(AuthorRole.SYSTEM, content);
    }

    public void clear() {
        this.chatMessageContents.clear();
    }

    public ChatHistory addAll(List<ChatMessageContent<?>> messages) {
        this.chatMessageContents.addAll(messages);
        return this;
    }
}

