/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.textcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.ai.AIException;
import com.microsoft.semantickernel.chatcompletion.ChatRequestSettings;
import com.microsoft.semantickernel.connectors.ai.openai.azuresdk.ClientBase;
import com.microsoft.semantickernel.exceptions.NotSupportedException;
import com.microsoft.semantickernel.textcompletion.CompletionRequestSettings;
import com.microsoft.semantickernel.textcompletion.CompletionType;
import com.microsoft.semantickernel.textcompletion.TextCompletion;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAITextCompletion
extends ClientBase
implements TextCompletion {
    private final CompletionType defaultCompletionType;

    @Inject
    public OpenAITextCompletion(OpenAIAsyncClient client, String modelId) {
        super(client, modelId);
        this.defaultCompletionType = CompletionType.STREAMING;
    }

    public OpenAITextCompletion(OpenAIAsyncClient client, String modelId, CompletionType defaultCompletionType) {
        super(client, modelId);
        this.defaultCompletionType = defaultCompletionType;
    }

    public Mono<List<String>> completeAsync(@Nonnull String text, @Nonnull CompletionRequestSettings requestSettings) {
        return this.internalCompleteTextAsync(text, requestSettings);
    }

    public Flux<String> completeStreamAsync(@Nonnull String text, @Nonnull CompletionRequestSettings requestSettings) {
        CompletionsOptions completionsOptions = this.getCompletionsOptions(text, requestSettings);
        return this.generateMessageStream(completionsOptions);
    }

    public CompletionType defaultCompletionType() {
        return this.defaultCompletionType;
    }

    private Flux<String> generateMessageStream(CompletionsOptions completionsOptions) {
        return this.getClient().getCompletionsStream(this.getModelId(completionsOptions), completionsOptions).groupBy(Completions::getId).concatMap(completionResult -> completionResult.concatMap(completion -> Flux.fromIterable((Iterable)completion.getChoices())).reduce((Object)"", OpenAITextCompletion.accumulateString()));
    }

    private static BiFunction<String, Choice, String> accumulateString() {
        return (newText, choice) -> {
            String message = choice.getText();
            if (!Verify.isNullOrEmpty((String)message)) {
                return newText + message;
            }
            return newText;
        };
    }

    protected Mono<List<String>> internalCompleteTextAsync(String text, CompletionRequestSettings requestSettings) {
        CompletionsOptions completionsOptions = this.getCompletionsOptions(text, requestSettings);
        return this.getClient().getCompletions(this.getModelId(requestSettings), completionsOptions).flatMapIterable(Completions::getChoices).mapNotNull(Choice::getText).collectList();
    }

    private String getModelId(CompletionRequestSettings requestSettings) {
        String model = requestSettings.getModelId();
        if (model == null) {
            model = this.getModelId();
        }
        return model;
    }

    private String getModelId(CompletionsOptions completionsOptions) {
        String model = completionsOptions.getModel();
        if (model == null) {
            model = this.getModelId();
        }
        return model;
    }

    private CompletionsOptions getCompletionsOptions(String text, CompletionRequestSettings requestSettings) {
        if (requestSettings.getMaxTokens() < 1) {
            throw new AIException(AIException.ErrorCodes.INVALID_REQUEST, "Max tokens must be >0");
        }
        CompletionsOptions options = new CompletionsOptions(Collections.singletonList(text)).setMaxTokens(Integer.valueOf(requestSettings.getMaxTokens())).setTemperature(Double.valueOf(requestSettings.getTemperature())).setTopP(Double.valueOf(requestSettings.getTopP())).setFrequencyPenalty(Double.valueOf(requestSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(requestSettings.getPresencePenalty())).setModel(this.getModelId(requestSettings)).setUser(requestSettings.getUser()).setBestOf(requestSettings.getBestOf()).setLogitBias(new HashMap());
        if (requestSettings instanceof ChatRequestSettings) {
            options = options.setStop(requestSettings.getStopSequences());
        }
        return options;
    }

    public static final class Builder
    implements TextCompletion.Builder {
        @Nullable
        private OpenAIAsyncClient client;
        @Nullable
        private String modelId;
        private CompletionType defaultCompletionType = CompletionType.STREAMING;

        public Builder withOpenAIClient(OpenAIAsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder withDefaultCompletionType(CompletionType completionType) {
            this.defaultCompletionType = completionType;
            return this;
        }

        public TextCompletion build() {
            if (this.client == null) {
                throw new NotSupportedException(NotSupportedException.ErrorCodes.NOT_SUPPORTED, "OpenAI client not set");
            }
            if (this.modelId == null) {
                throw new NotSupportedException(NotSupportedException.ErrorCodes.NOT_SUPPORTED, "Model ID not set");
            }
            return new OpenAITextCompletion(this.client, this.modelId, this.defaultCompletionType);
        }
    }
}

