/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.textcompletion;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.microsoft.semantickernel.ai.AIException;
import com.microsoft.semantickernel.connectors.ai.openai.azuresdk.ClientBase;
import com.microsoft.semantickernel.exceptions.NotSupportedException;
import com.microsoft.semantickernel.textcompletion.CompletionRequestSettings;
import com.microsoft.semantickernel.textcompletion.TextCompletion;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public class OpenAITextCompletion
extends ClientBase
implements TextCompletion {
    @Inject
    public OpenAITextCompletion(OpenAIAsyncClient client, String modelId) {
        super(client, modelId);
    }

    public Mono<List<String>> completeAsync(@Nonnull String text, @Nonnull CompletionRequestSettings requestSettings) {
        return this.internalCompleteTextAsync(text, requestSettings);
    }

    protected Mono<List<String>> internalCompleteTextAsync(String text, CompletionRequestSettings requestSettings) {
        if (requestSettings.getMaxTokens() < 1) {
            throw new AIException(AIException.ErrorCodes.InvalidRequest, "Max tokens must be >0");
        }
        CompletionsOptions completionsOptions = new CompletionsOptions(Collections.singletonList(text)).setMaxTokens(Integer.valueOf(requestSettings.getMaxTokens())).setTemperature(Double.valueOf(requestSettings.getTemperature())).setTopP(Double.valueOf(requestSettings.getTopP())).setFrequencyPenalty(Double.valueOf(requestSettings.getFrequencyPenalty())).setPresencePenalty(Double.valueOf(requestSettings.getPresencePenalty())).setModel(this.getModelId()).setUser(requestSettings.getUser()).setBestOf(requestSettings.getBestOf()).setLogitBias(new HashMap());
        return this.getClient().getCompletions(this.getModelId(), completionsOptions).flatMapIterable(Completions::getChoices).mapNotNull(Choice::getText).collectList();
    }

    public static final class Builder
    implements TextCompletion.Builder {
        @Nullable
        private OpenAIAsyncClient client;
        @Nullable
        private String modelId;

        public Builder withOpenAIClient(OpenAIAsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public TextCompletion build() {
            if (this.client == null) {
                throw new NotSupportedException("OpenAI client not set");
            }
            if (this.modelId == null) {
                throw new NotSupportedException("Model ID not set");
            }
            return new OpenAITextCompletion(this.client, this.modelId);
        }
    }
}

