/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.util;

import com.microsoft.semantickernel.connectors.ai.openai.util.AbstractOpenAIClientSettings;
import com.microsoft.semantickernel.exceptions.ConfigurationException;
import java.util.Map;
import javax.annotation.Nullable;

public class AzureOpenAISettings
extends AbstractOpenAIClientSettings {
    private static final String DEFAULT_SETTINGS_PREFIX = "client.azureopenai";
    private static final String AZURE_OPEN_AI_ENDPOINT_SUFFIX = "endpoint";
    private static final String AZURE_OPEN_AI_DEPLOYMENT_NAME_SUFFIX = "deploymentname";
    @Nullable
    private final String key;
    @Nullable
    private final String endpoint;
    @Nullable
    private final String deploymentName;
    private final String settingsPrefix;

    public AzureOpenAISettings(Map<String, String> settings) {
        this(DEFAULT_SETTINGS_PREFIX, settings);
    }

    public AzureOpenAISettings(String settingsPrefix, Map<String, String> settings) {
        this.settingsPrefix = settingsPrefix;
        this.key = settings.get(settingsPrefix + "." + "key");
        this.endpoint = settings.get(settingsPrefix + "." + AZURE_OPEN_AI_ENDPOINT_SUFFIX);
        this.deploymentName = settings.get(settingsPrefix + "." + AZURE_OPEN_AI_DEPLOYMENT_NAME_SUFFIX);
    }

    public String getEndpoint() throws ConfigurationException {
        if (this.endpoint == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, AZURE_OPEN_AI_ENDPOINT_SUFFIX);
        }
        return this.endpoint;
    }

    public String getDeploymentName() throws ConfigurationException {
        if (this.deploymentName == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, AZURE_OPEN_AI_DEPLOYMENT_NAME_SUFFIX);
        }
        return this.deploymentName;
    }

    @Override
    public String getKey() throws ConfigurationException {
        if (this.key == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, "key");
        }
        return this.key;
    }

    @Override
    public boolean assertIsValid() throws ConfigurationException {
        if (this.key == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, this.settingsPrefix + "." + "key");
        }
        if (this.endpoint == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, this.settingsPrefix + "." + AZURE_OPEN_AI_ENDPOINT_SUFFIX);
        }
        return true;
    }
}

