/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.util;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.models.NonAzureOpenAIKeyCredential;
import com.azure.core.credential.AzureKeyCredential;
import com.microsoft.semantickernel.connectors.ai.openai.util.AzureOpenAISettings;
import com.microsoft.semantickernel.connectors.ai.openai.util.ClientType;
import com.microsoft.semantickernel.connectors.ai.openai.util.OpenAISettings;
import com.microsoft.semantickernel.connectors.ai.openai.util.SettingsMap;
import com.microsoft.semantickernel.exceptions.ConfigurationException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIClientProvider {
    private static final Logger LOGGER;
    public static final String OPENAI_CLIENT_TYPE = "OPENAI_CLIENT_TYPE";
    @Nullable
    private static final OpenAIClientProvider DEFAULT_INST;
    @Nullable
    private final ClientType clientType;
    private final Map<String, String> configuredSettings;

    public OpenAIClientProvider(Map<String, String> configuredSettings, @Nullable ClientType clientType) {
        this.configuredSettings = Collections.unmodifiableMap(configuredSettings);
        this.clientType = clientType;
    }

    private static OpenAIClientProvider buildProvider(@Nullable List<File> propertyFileLocations, @Nullable ClientType clientType) throws ConfigurationException {
        String clientValue;
        Map<String, String> settings = OpenAIClientProvider.getSettings(propertyFileLocations);
        if (clientType == null && (clientValue = settings.get(OPENAI_CLIENT_TYPE)) != null) {
            clientType = ClientType.valueOf(clientValue);
        }
        return new OpenAIClientProvider(settings, clientType);
    }

    private static Map<String, String> getSettings(@Nullable List<File> propertyFileLocations) throws ConfigurationException {
        Map<String, String> settings = propertyFileLocations != null ? SettingsMap.get(propertyFileLocations) : SettingsMap.getDefault();
        return settings;
    }

    public static OpenAIAsyncClient get(List<File> propertyFileLocations, @Nullable ClientType clientType) throws ConfigurationException {
        return OpenAIClientProvider.buildProvider(propertyFileLocations, clientType).getAsyncClient();
    }

    public static OpenAIAsyncClient get(List<File> propertyFileLocations) throws ConfigurationException {
        return OpenAIClientProvider.get(propertyFileLocations, null);
    }

    public static OpenAIAsyncClient getWithAdditional(List<File> propertyFileLocations, @Nullable ClientType clientType) throws ConfigurationException {
        Map<String, String> settings = SettingsMap.getWithAdditional(propertyFileLocations);
        if (clientType == null && settings.containsKey(OPENAI_CLIENT_TYPE)) {
            clientType = ClientType.valueOf(settings.get(OPENAI_CLIENT_TYPE));
        }
        return new OpenAIClientProvider(settings, clientType).getAsyncClient();
    }

    public static OpenAIAsyncClient getWithAdditional(List<File> propertyFileLocations) throws ConfigurationException {
        return OpenAIClientProvider.getWithAdditional(propertyFileLocations, null);
    }

    public static OpenAIAsyncClient getClient() throws ConfigurationException {
        if (DEFAULT_INST == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.NoValidConfigurationsFound);
        }
        return DEFAULT_INST.getAsyncClient();
    }

    public OpenAIAsyncClient getAsyncClient() throws ConfigurationException {
        if (this.clientType == null) {
            LOGGER.debug("No OpenAI client type specified, searching for a valid client type");
            try {
                LOGGER.debug("Trying OpenAI client");
                OpenAIAsyncClient client = this.buildOpenAIClient();
                LOGGER.debug("Successfully instantiated OpenAI client");
                return client;
            }
            catch (ConfigurationException e) {
                LOGGER.debug("No OpenAI client found");
                try {
                    LOGGER.debug("Trying Azure OpenAI client");
                    OpenAIAsyncClient client = this.buildAzureOpenAIClient();
                    LOGGER.debug("Successfully instantiated Azure OpenAI client");
                    return client;
                }
                catch (ConfigurationException e2) {
                    LOGGER.debug("No Azure OpenAI client found");
                    throw new ConfigurationException(ConfigurationException.ErrorCodes.NoValidConfigurationsFound);
                }
            }
        }
        switch (this.clientType) {
            case OPEN_AI: {
                return this.buildOpenAIClient();
            }
            case AZURE_OPEN_AI: {
                return this.buildAzureOpenAIClient();
            }
        }
        throw new ConfigurationException(ConfigurationException.ErrorCodes.NoValidConfigurationsFound);
    }

    private OpenAIAsyncClient buildOpenAIClient() throws ConfigurationException {
        OpenAISettings settings = new OpenAISettings(this.configuredSettings);
        try {
            settings.assertIsValid();
        }
        catch (ConfigurationException e) {
            LOGGER.warn("Settings are not valid for OpenAI client");
            LOGGER.warn(e.getMessage());
            throw e;
        }
        return new OpenAIClientBuilder().credential(new NonAzureOpenAIKeyCredential(settings.getKey())).buildAsyncClient();
    }

    private OpenAIAsyncClient buildAzureOpenAIClient() throws ConfigurationException {
        AzureOpenAISettings settings = new AzureOpenAISettings(this.configuredSettings);
        try {
            settings.assertIsValid();
        }
        catch (ConfigurationException e) {
            LOGGER.warn("Could not instantiate Azure OpenAI client");
            LOGGER.warn(e.getMessage());
            throw e;
        }
        OpenAIClientBuilder builder = new OpenAIClientBuilder().endpoint(settings.getEndpoint()).credential(new AzureKeyCredential(settings.getKey()));
        return builder.buildAsyncClient();
    }

    static {
        OpenAIClientProvider DEFAULT_INST_TMP;
        LOGGER = LoggerFactory.getLogger(OpenAIClientProvider.class);
        try {
            DEFAULT_INST_TMP = OpenAIClientProvider.buildProvider(null, null);
        }
        catch (ConfigurationException e) {
            LOGGER.error("Failed to load default settings", (Throwable)e);
            DEFAULT_INST_TMP = null;
        }
        DEFAULT_INST = DEFAULT_INST_TMP;
    }
}

