/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.util;

import com.microsoft.semantickernel.connectors.ai.openai.util.AbstractOpenAIClientSettings;
import com.microsoft.semantickernel.exceptions.ConfigurationException;
import java.util.Map;
import javax.annotation.Nullable;

public class OpenAISettings
extends AbstractOpenAIClientSettings {
    public static final String OPEN_AI_ORGANIZATION_SUFFIX = "organizationid";
    private static final String DEFAULT_SETTINGS_PREFIX = "client.openai";
    @Nullable
    private final String key;
    @Nullable
    private final String organizationId;
    private final String settingsPrefix;

    public OpenAISettings(Map<String, String> settings) {
        this(DEFAULT_SETTINGS_PREFIX, settings);
    }

    public OpenAISettings(String settingsPrefix, Map<String, String> settings) {
        this.settingsPrefix = settingsPrefix;
        this.key = settings.get(settingsPrefix + "." + "key");
        this.organizationId = settings.get(settingsPrefix + "." + OPEN_AI_ORGANIZATION_SUFFIX);
    }

    @Override
    public String getKey() throws ConfigurationException {
        if (this.key == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, "key");
        }
        return this.key;
    }

    public String getOrganizationId() throws ConfigurationException {
        if (this.organizationId == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, OPEN_AI_ORGANIZATION_SUFFIX);
        }
        return this.organizationId;
    }

    @Override
    public boolean assertIsValid() throws ConfigurationException {
        if (this.key == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.ValueNotFound, this.settingsPrefix + "." + "key");
        }
        return true;
    }
}

