/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.util;

import com.microsoft.semantickernel.exceptions.ConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsMap.class);
    public static final String CONF_PROPERTIES_NAME = "CONF_PROPERTIES";
    public static final String CONF_PROPERTIES = SettingsMap.getEnvOrProperty("CONF_PROPERTIES", "conf.properties");
    private static final List<File> DEFAULT_PROPERTIES_LOCATIONS = Arrays.asList(new File(new File(System.getProperty("user.home"), ".sk"), "conf.properties"), new File("conf.properties"));
    @Nullable
    private static Map<String, String> DEFAULT_INST;

    private static void initSettings() {
        Map<String, String> DEFAULT_INST_TMP;
        if (DEFAULT_INST != null) {
            return;
        }
        try {
            DEFAULT_INST_TMP = SettingsMap.get(DEFAULT_PROPERTIES_LOCATIONS);
        }
        catch (ConfigurationException e) {
            LOGGER.error("Failed to load settings", (Throwable)e);
            DEFAULT_INST_TMP = null;
        }
        DEFAULT_INST = DEFAULT_INST_TMP;
    }

    public static Map<String, String> getDefault() throws ConfigurationException {
        SettingsMap.initSettings();
        if (DEFAULT_INST == null) {
            throw new ConfigurationException(ConfigurationException.ErrorCodes.NO_VALID_CONFIGURATIONS_FOUND);
        }
        return Collections.unmodifiableMap(DEFAULT_INST);
    }

    public static Map<String, String> get(List<File> propertyFileLocations) throws ConfigurationException {
        return Collections.unmodifiableMap(SettingsMap.loadAllSettings(propertyFileLocations));
    }

    public static Map<String, String> getWithAdditional(List<File> propertyFileLocations) throws ConfigurationException {
        ArrayList<File> locations = new ArrayList<File>(DEFAULT_PROPERTIES_LOCATIONS);
        locations.addAll(propertyFileLocations);
        return SettingsMap.get(locations);
    }

    private static Map<String, String> loadAllSettings(List<File> propertyFileLocations) throws ConfigurationException {
        Properties properties = new Properties();
        if (SettingsMap.getEnvOrProperty(CONF_PROPERTIES_NAME, null) != null) {
            if (Files.isRegularFile(new File(CONF_PROPERTIES).toPath(), new LinkOption[0])) {
                try (FileInputStream fis = new FileInputStream(CONF_PROPERTIES);){
                    properties.load(fis);
                }
                catch (FileNotFoundException e) {
                    throw new ConfigurationException(ConfigurationException.ErrorCodes.CONFIGURATION_NOT_FOUND, CONF_PROPERTIES);
                }
                catch (IOException e) {
                    throw new ConfigurationException(ConfigurationException.ErrorCodes.COULD_NOT_READ_CONFIGURATION, CONF_PROPERTIES);
                }
            }
        } else {
            propertyFileLocations.forEach(file -> {
                if (Files.isRegularFile(file.toPath(), new LinkOption[0])) {
                    try (FileInputStream fis = new FileInputStream((File)file);){
                        properties.load(fis);
                        LOGGER.info("Added settings from: {}", file);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.info("No config file found at: {}", file);
                    }
                    catch (IOException e) {
                        LOGGER.info("Failed to read config file at: {}", file);
                    }
                } else {
                    LOGGER.info("Did not find configuration file: {}", file);
                }
            });
        }
        Map<String, String> envVariables = System.getenv().entrySet().stream().collect(Collectors.toMap(key -> ((String)key.getKey()).toLowerCase().replace("_", "."), Map.Entry::getValue));
        properties.putAll(envVariables);
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties.stringPropertyNames().stream().collect(HashMap::new, (m, k) -> m.put(k, properties.getProperty((String)k)), HashMap::putAll);
    }

    private static String getEnvOrProperty(String propertyName, String defaultValue) {
        String env = System.getenv(propertyName);
        if (env != null && !env.isEmpty()) {
            return env;
        }
        String property = System.getProperty(propertyName);
        if (property != null && !property.isEmpty()) {
            return property;
        }
        return defaultValue;
    }
}

