/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.actionplanner;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.AbstractSkFunction;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.orchestration.WritableContextVariables;
import com.microsoft.semantickernel.skilldefinition.FunctionView;
import com.microsoft.semantickernel.skilldefinition.KernelSkillsSupplier;
import com.microsoft.semantickernel.skilldefinition.ParameterView;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import com.microsoft.semantickernel.textcompletion.CompletionRequestSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Plan
extends AbstractSkFunction<CompletionRequestSettings> {
    private static final Pattern s_variablesRegex = Pattern.compile("\\$(\\w+)", 8);
    private static final String DefaultResultKey = "PLAN.RESULT";
    private ContextVariables state;
    private final List<Plan> steps = new ArrayList<Plan>();
    @Nullable
    private ContextVariables parameters;
    private List<String> outputs = new ArrayList<String>();
    @Nullable
    private SKFunction<?> function = null;

    public Plan(String goal, ContextVariables state, @Nullable KernelSkillsSupplier kernelSkillsSupplier) {
        super(new ArrayList(), Plan.class.getName(), "", goal, kernelSkillsSupplier);
        this.state = state;
    }

    public Plan(String goal, @Nullable KernelSkillsSupplier kernelSkillsSupplier) {
        this(goal, (ContextVariables)SKBuilders.variables().build(), kernelSkillsSupplier);
    }

    public Plan(SKFunction<?> function, ContextVariables state, List<String> functionOutputs, KernelSkillsSupplier kernelSkillsSupplier) {
        super(function.describe().getParameters(), function.getSkillName(), function.getName(), function.getDescription(), kernelSkillsSupplier);
        this.parameters = null;
        this.function = function;
        this.outputs = new ArrayList<String>(functionOutputs);
        this.state = state;
    }

    public Plan(SKFunction<?> function, @Nullable ContextVariables parameters, ContextVariables state, List<String> functionOutputs, KernelSkillsSupplier kernelSkillsSupplier) {
        super(function.describe().getParameters(), function.getSkillName(), function.getName(), function.getDescription(), kernelSkillsSupplier);
        this.parameters = parameters;
        this.function = function;
        this.outputs = new ArrayList<String>(functionOutputs);
        this.state = state;
    }

    public Plan(SKFunction<?> function, List<String> functionOutputs, KernelSkillsSupplier kernelSkillsSupplier) {
        this(function, (ContextVariables)SKBuilders.variables().build(), functionOutputs, kernelSkillsSupplier);
    }

    public Plan(SKFunction<?> function, KernelSkillsSupplier kernelSkillsSupplier) {
        this(function, (ContextVariables)SKBuilders.variables().build(), new ArrayList<String>(), kernelSkillsSupplier);
    }

    public Plan(String goal, ContextVariables parameters, KernelSkillsSupplier kernelSkillsSupplier, SKFunction<?> ... steps) {
        this(goal, parameters, kernelSkillsSupplier);
        this.addSteps(steps);
    }

    public Plan(String goal, KernelSkillsSupplier kernelSkillsSupplier, SKFunction<?> ... steps) {
        this(goal, kernelSkillsSupplier);
        this.addSteps(steps);
    }

    public void registerOnKernel(Kernel kernel) {
        kernel.registerSemanticFunction((SKFunction)this);
    }

    @Nullable
    public FunctionView describe() {
        if (this.function == null) {
            return null;
        }
        return this.function.describe();
    }

    @Nullable
    public Class getType() {
        if (this.function == null) {
            return null;
        }
        return this.function.getType();
    }

    public void addSteps(Plan ... steps) {
        this.steps.addAll(Arrays.asList(steps));
    }

    public void addSteps(SKFunction<?> ... steps) {
        List plans = Arrays.stream(steps).map(step -> new Plan((SKFunction<?>)step, this.getSkillsSupplier())).collect(Collectors.toList());
        this.steps.addAll(plans);
    }

    public void setParameters(ContextVariables functionVariables) {
        this.parameters = functionVariables;
    }

    public void addOutputs(List<String> outputs) {
        this.outputs.addAll(outputs);
    }

    public Mono<SKContext> invokeNextStepAsync(SKContext context, @Nullable CompletionRequestSettings settings) {
        SKContext initialContext = (SKContext)SKBuilders.context().setVariables((ContextVariables)context.getVariables().writableClone()).setMemory(context.getSemanticMemory()).setSkills(context.getSkills()).build();
        return Flux.fromIterable(this.steps).reduce((Object)Mono.just((Object)initialContext), (currentContext, step) -> this.executeStep(context, settings, (Mono<SKContext>)currentContext, (Plan)((Object)step))).flux().concatMap(it -> it).last((Object)((SKContext)SKBuilders.context().build())).map(result -> {
            if (result.getVariables().get(DefaultResultKey) != null) {
                result = result.update(result.getVariables().get(DefaultResultKey));
            }
            return result;
        });
    }

    private Mono<SKContext> executeStep(SKContext context, @Nullable CompletionRequestSettings settings, Mono<SKContext> currentContext2, Plan step) {
        return currentContext2.flatMap(currentContext -> {
            ContextVariables functionVariables = this.getNextStepVariables(currentContext.getVariables(), step);
            SKContext functionContext = (SKContext)SKBuilders.context().setVariables(functionVariables).setMemory(context.getSemanticMemory()).setSkills(context.getSkills()).build();
            return step.invokeAsync(functionContext, settings).flatMap(result -> {
                String resultValue = result.getResult();
                if (resultValue == null) {
                    return Mono.error((Throwable)new RuntimeException("No result returned"));
                }
                resultValue = resultValue.trim();
                WritableContextVariables updatedContext = currentContext.getVariables().writableClone();
                String finalResultValue = resultValue;
                step.outputs.forEach(item -> {
                    if (result.getVariables().asMap().containsKey(item)) {
                        String variable = result.getVariables().get(item);
                        if (variable != null) {
                            updatedContext.setVariable(item, variable);
                        }
                    } else {
                        updatedContext.setVariable(item, finalResultValue);
                    }
                });
                if (step.outputs.size() > 0) {
                    updatedContext.setVariable("input", currentContext.getResult());
                } else {
                    updatedContext.update(finalResultValue);
                }
                updatedContext.setVariable(DefaultResultKey, finalResultValue);
                return Mono.just((Object)((SKContext)SKBuilders.context().clone(context).setVariables((ContextVariables)updatedContext).build()));
            });
        });
    }

    public Mono<SKContext> invokeAsync(@Nullable String input, @Nullable CompletionRequestSettings settings, @Nullable SemanticTextMemory memory) {
        WritableContextVariables variables = this.state.writableClone();
        if (input != null) {
            variables.update(input);
        }
        KernelSkillsSupplier skillsSupplier = this.getSkillsSupplier();
        SKContext context = (SKContext)SKBuilders.context().setVariables((ContextVariables)variables).setMemory(memory).setSkills(skillsSupplier == null ? null : (ReadOnlySkillCollection)skillsSupplier.get()).build();
        return this.invokeAsync(context, settings);
    }

    public Mono<SKContext> invokeAsync(@Nullable String input, @Nullable SKContext context, @Nullable CompletionRequestSettings settings) {
        if (input != null) {
            this.state = this.state.writableClone().update(input);
        }
        if (context == null) {
            context = (SKContext)SKBuilders.context().setVariables(this.state).setSkills(this.getSkillsSupplier() == null ? null : (ReadOnlySkillCollection)this.getSkillsSupplier().get()).build();
        } else {
            ContextVariables variables = context.getVariables().writableClone().update(this.state, true);
            context = context.update(variables);
        }
        return super.invokeAsync(input, context, (Object)settings);
    }

    protected Mono<SKContext> invokeAsyncInternal(SKContext contextIn, @Nullable CompletionRequestSettings settings) {
        if (this.function != null) {
            return this.function.invokeAsync(contextIn, (Object)settings);
        }
        SKContext c = Plan.addVariablesToContext(this.state, contextIn);
        return this.invokeNextStepAsync(c, null);
    }

    private String expandFromVariables(ContextVariables variables, String input) {
        String result = input;
        Matcher matches = s_variablesRegex.matcher(input);
        while (matches.find()) {
            String varName = matches.group(1);
            String value = variables.get(varName);
            if (value == null) {
                value = this.state.get(varName);
            }
            if (value == null) {
                value = "";
            }
            result = result.replaceAll("\\$" + varName, value);
        }
        return result;
    }

    private static SKContext addVariablesToContext(ContextVariables vars, SKContext context) {
        WritableContextVariables clone = context.getVariables().writableClone();
        vars.asMap().forEach((key, value) -> {
            if (Verify.isNullOrEmpty((String)clone.get(key))) {
                clone.setVariable(key, value);
            }
        });
        return (SKContext)SKBuilders.context().clone(context).setVariables((ContextVariables)clone).build();
    }

    private ContextVariables getNextStepVariables(ContextVariables variables, Plan step) {
        String input = "";
        if (step.parameters != null && !Verify.isNullOrEmpty((String)step.parameters.getInput()) && !step.parameters.getInput().equals("SKFunctionParameters__NO_INPUT_PROVIDED")) {
            input = this.expandFromVariables(variables, Objects.requireNonNull(step.parameters.getInput()));
        } else if (!Verify.isNullOrEmpty((String)variables.getInput())) {
            input = Objects.requireNonNull(variables.getInput());
        } else if (!Verify.isNullOrEmpty((String)this.state.getInput())) {
            input = Objects.requireNonNull(this.state.getInput());
        } else if (this.steps.size() > 0) {
            input = "";
        } else if (!Verify.isNullOrEmpty((String)this.getDescription())) {
            input = this.getDescription();
        }
        WritableContextVariables stepVariables = ((ContextVariables)SKBuilders.variables().withInput(Objects.requireNonNull(input)).build()).writableClone();
        FunctionView functionParameters = step.describe();
        if (functionParameters != null) {
            for (ParameterView param : functionParameters.getParameters()) {
                String variable;
                if (param.getName().equals("input")) continue;
                if (!Verify.isNullOrEmpty((String)variables.get(param.getName()))) {
                    variable = Objects.requireNonNull(variables.get(param.getName()));
                    stepVariables.setVariable(param.getName(), variable);
                    continue;
                }
                if (Verify.isNullOrEmpty((String)this.state.get(param.getName()))) continue;
                variable = Objects.requireNonNull(this.state.get(param.getName()));
                stepVariables.setVariable(param.getName(), variable);
            }
        }
        if (step.parameters != null) {
            step.parameters.asMap().forEach((key, value) -> {
                if (!Verify.isNullOrEmpty((String)stepVariables.get(key))) {
                    return;
                }
                String expandedValue = this.expandFromVariables(variables, (String)value);
                if (expandedValue != null && !expandedValue.equalsIgnoreCase((String)value)) {
                    stepVariables.setVariable(key, expandedValue);
                } else if (!Verify.isNullOrEmpty((String)variables.get(key))) {
                    String variable = variables.get(key);
                    if (variable != null) {
                        stepVariables.setVariable(key, variable);
                    }
                } else if (!Verify.isNullOrEmpty((String)this.state.get(key))) {
                    String variable = this.state.get(key);
                    if (variable != null) {
                        stepVariables.setVariable(key, variable);
                    }
                } else if (expandedValue != null) {
                    stepVariables.setVariable(key, expandedValue);
                }
            });
        }
        return stepVariables;
    }

    public String toPlanString() {
        return this.toPlanString("  ");
    }

    private String toPlanString(String indent) {
        String goalHeader = indent + "Goal: " + this.getDescription() + "\n\n" + indent + "Steps:\n";
        String stepItems = this.steps.stream().map(step -> Plan.stepToString(indent, step)).collect(Collectors.joining("\n"));
        return goalHeader + stepItems;
    }

    private static String stepToString(String indent, Plan step) {
        if (step.steps.size() == 0) {
            String outputs;
            String skillName = step.getSkillName();
            String stepName = step.getName();
            String parameters = step.getParametersView().stream().map(param -> {
                String value = param.getDefaultValue();
                if (step.getParameters() != null && step.getParameters().get(param.getName()) != null) {
                    value = step.getParameters().get(param.getName());
                }
                return "\t" + param.getName() + ": \"" + value + "\"";
            }).collect(Collectors.joining(" "));
            if (!Verify.isNullOrEmpty((String)parameters)) {
                parameters = " " + parameters;
            }
            if (!Verify.isNullOrEmpty((String)(outputs = step.outputs.stream().findFirst().orElse("")))) {
                outputs = " => " + outputs;
            }
            return indent + indent + "- " + String.join((CharSequence)".", skillName, stepName) + "\t\t\t" + parameters + outputs;
        }
        return step.toPlanString(indent + indent);
    }

    @Nullable
    private ContextVariables getParameters() {
        return this.parameters;
    }
}

