/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.sequentialplanner;

import com.microsoft.semantickernel.memory.MemoryQueryResult;
import com.microsoft.semantickernel.memory.NullMemory;
import com.microsoft.semantickernel.memory.SemanticTextMemory;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.planner.sequentialplanner.SequentialPlannerRequestSettings;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultSequentialPlannerSKContext {
    public static final String PlannerMemoryCollectionName = "Planning.SKFunctionsManual";
    public static final String PlanSKFunctionsAreRemembered = "Planning.SKFunctionsAreRemembered";
    private final SKContext delegate;

    public DefaultSequentialPlannerSKContext(SKContext delegate) {
        this.delegate = delegate;
    }

    public Mono<String> getFunctionsManualAsync(@Nullable String semanticQuery, @Nullable SequentialPlannerRequestSettings config) {
        if (config == null) {
            config = new SequentialPlannerRequestSettings();
        }
        Mono<SortedSet<SKFunction<?>>> functions = this.getAvailableFunctionsAsync(config, semanticQuery);
        return functions.map(funcs -> funcs.stream().map(SKFunction::toManualString).collect(Collectors.joining("\n\n")));
    }

    public Mono<SortedSet<SKFunction<?>>> getAvailableFunctionsAsync(SequentialPlannerRequestSettings config, @Nullable String semanticQuery) {
        Set<String> excludedSkills = config.getExcludedSkills();
        Set<String> excludedFunctions = config.getExcludedFunctions();
        Set<String> includedFunctions = config.getIncludedFunctions();
        ReadOnlySkillCollection skills = this.delegate.getSkills();
        List functions = skills != null ? skills.getAllFunctions().getAll() : Collections.emptyList();
        List<SKFunction<?>> availableFunctions = functions.stream().filter(s -> !excludedSkills.contains(s.getSkillName()) && !excludedFunctions.contains(s.getName())).collect(Collectors.toList());
        Comparator<SKFunction> comparator = Comparator.comparing(SKFunction::getSkillName).thenComparing(SKFunction::getName);
        if (semanticQuery == null || semanticQuery.isEmpty() || this.delegate.getSemanticMemory() == null || this.delegate.getSemanticMemory() instanceof NullMemory || config.getRelevancyThreshold() == null) {
            TreeSet<SKFunction> result = new TreeSet<SKFunction>(comparator);
            result.addAll(availableFunctions);
            return Mono.just(result);
        }
        return this.rememberFunctionsAsync(availableFunctions).flatMap(updatedContext -> {
            SemanticTextMemory updatedMemory = updatedContext.getSemanticMemory();
            if (updatedMemory == null) {
                return Mono.just(new ArrayList());
            }
            return updatedMemory.searchAsync(PlannerMemoryCollectionName, semanticQuery, config.getMaxRelevantFunctions(), config.getRelevancyThreshold().doubleValue(), false).flatMap(memories -> this.getRelevantFunctionsAsync(availableFunctions, (List<MemoryQueryResult>)memories));
        }).map(memories -> {
            List<String> added = memories.stream().map(SKFunction::getName).collect(Collectors.toList());
            List<SKFunction<?>> missingFunctions = DefaultSequentialPlannerSKContext.getMissingFunctions(includedFunctions, availableFunctions, added);
            ArrayList res = new ArrayList((Collection<SKFunction<?>>)memories);
            res.addAll(missingFunctions);
            return res;
        }).map(res -> {
            TreeSet result = new TreeSet(comparator);
            result.addAll(availableFunctions);
            return result;
        });
    }

    private static List<SKFunction<?>> getMissingFunctions(Set<String> includedFunctions, List<SKFunction<?>> availableFunctions, List<String> added) {
        return includedFunctions.stream().filter(func -> !added.contains(func)).flatMap(missing -> availableFunctions.stream().filter(it -> it.getName().equals(missing))).collect(Collectors.toList());
    }

    public Mono<? extends List<? extends SKFunction<?>>> getRelevantFunctionsAsync(List<SKFunction<?>> availableFunctions, List<MemoryQueryResult> memories) {
        return Flux.fromIterable(memories).map(memoryEntry -> availableFunctions.stream().filter(it -> Objects.equals(it.toFullyQualifiedName(), memoryEntry.getMetadata().getId())).findFirst().orElse(null)).filter(Objects::nonNull).collectList();
    }

    Mono<SKContext> rememberFunctionsAsync(List<SKFunction<?>> availableFunctions) {
        if (this.delegate.getVariables().asMap().containsKey(PlanSKFunctionsAreRemembered)) {
            return Mono.just((Object)this.delegate);
        }
        SemanticTextMemory memory = this.delegate.getSemanticMemory();
        if (memory == null) {
            this.delegate.setVariable(PlanSKFunctionsAreRemembered, "true");
            return Mono.just((Object)this.delegate);
        }
        return Flux.fromIterable(availableFunctions).concatMap(function -> {
            String functionName;
            String key = functionName = function.toFullyQualifiedName();
            String description = function.getDescription() == null || function.getDescription().isEmpty() ? functionName : function.getDescription();
            String textToEmbed = function.toEmbeddingString();
            return memory.getAsync(PlannerMemoryCollectionName, key, false).filter(Objects::nonNull).flatMap(memoryEntry -> memory.saveInformationAsync(PlannerMemoryCollectionName, textToEmbed, key, description, "")).flatMap(newKey -> memory.getAsync(PlannerMemoryCollectionName, newKey, true));
        }).ignoreElements().map(newMemory -> {
            this.delegate.setVariable(PlanSKFunctionsAreRemembered, "true");
            return this.delegate;
        });
    }
}

