/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.sequentialplanner;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.planner.PlanningException;
import com.microsoft.semantickernel.planner.actionplanner.Plan;
import com.microsoft.semantickernel.planner.sequentialplanner.DefaultSequentialPlannerSKContext;
import com.microsoft.semantickernel.planner.sequentialplanner.EmbeddedResource;
import com.microsoft.semantickernel.planner.sequentialplanner.SequentialPlanParser;
import com.microsoft.semantickernel.planner.sequentialplanner.SequentialPlannerRequestSettings;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SequentialPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SequentialPlanner.class);
    private static final String StopSequence = "<!--";
    private static final String RestrictedSkillName = "SequentialPlanner_Excluded";
    private final SequentialPlannerRequestSettings config;
    private final CompletionSKFunction functionFlowFunction;
    private final Kernel kernel;

    public SequentialPlanner(Kernel kernel, @Nullable SequentialPlannerRequestSettings config, @Nullable String prompt) {
        if (config == null) {
            config = new SequentialPlannerRequestSettings();
        }
        this.config = config.addExcludedSkillName(RestrictedSkillName);
        String promptTemplate = prompt != null ? prompt : EmbeddedResource.read("skprompt.txt");
        this.functionFlowFunction = (CompletionSKFunction)SKBuilders.completionFunctions().withKernel(kernel).setPromptTemplate(promptTemplate).setSkillName(RestrictedSkillName).setDescription("Given a request or command or goal generate a step by step plan to fulfill the request using functions. This ability is also known as decision making and function flow").setCompletionConfig(new PromptTemplateConfig.CompletionConfig(0.0, 0.0, 0.0, 0.0, this.config.getMaxTokens())).build();
        this.kernel = kernel;
    }

    public Mono<Plan> createPlanAsync(String goal) {
        return this.createPlanAsync(goal, (SKContext)SKBuilders.context().withKernel(this.kernel).build());
    }

    public Mono<Plan> createPlanAsync(String goal, SKContext context) {
        if (goal == null || goal.isEmpty()) {
            throw new PlanningException(PlanningException.ErrorCodes.InvalidGoal, "The goal specified is empty");
        }
        try {
            return new DefaultSequentialPlannerSKContext(context).getFunctionsManualAsync(goal, this.config).flatMap(relevantFunctionsManual -> {
                SKContext updatedContext = context.setVariable("available_functions", relevantFunctionsManual).update(goal);
                return this.functionFlowFunction.invokeAsync(updatedContext, null);
            }).map(planResult -> {
                String planResultString = planResult.getResult().trim();
                LOGGER.debug("Plan result: " + planResultString);
                Plan plan = SequentialPlanParser.toPlanFromXml(planResultString, goal, context.getSkills());
                return plan;
            });
        }
        catch (Exception e) {
            throw new PlanningException(PlanningException.ErrorCodes.InvalidPlan, "Plan parsing error, invalid XML", (Throwable)e);
        }
    }
}

