/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.sequentialplanner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class SequentialPlannerRequestSettings {
    @Nullable
    private Double relevancyThreshold = null;
    private int maxRelevantFunctions = 100;
    private Set<String> excludedSkills = new HashSet<String>();
    private Set<String> excludedFunctions = new HashSet<String>();
    private Set<String> includedFunctions = new HashSet<String>();
    private int maxTokens = 1024;

    public SequentialPlannerRequestSettings(@Nullable Double relevancyThreshold, int maxRelevantFunctions, Set<String> excludedSkills, Set<String> excludedFunctions, Set<String> includedFunctions, int maxTokens) {
        this.relevancyThreshold = relevancyThreshold;
        this.maxRelevantFunctions = maxRelevantFunctions;
        this.excludedSkills = Collections.unmodifiableSet(excludedSkills);
        this.excludedFunctions = Collections.unmodifiableSet(excludedFunctions);
        this.includedFunctions = Collections.unmodifiableSet(includedFunctions);
        this.maxTokens = maxTokens;
    }

    public SequentialPlannerRequestSettings() {
    }

    @Nullable
    public Double getRelevancyThreshold() {
        return this.relevancyThreshold;
    }

    public int getMaxRelevantFunctions() {
        return this.maxRelevantFunctions;
    }

    public Set<String> getExcludedSkills() {
        return Collections.unmodifiableSet(this.excludedSkills);
    }

    public Set<String> getExcludedFunctions() {
        return Collections.unmodifiableSet(this.excludedFunctions);
    }

    public Set<String> getIncludedFunctions() {
        return Collections.unmodifiableSet(this.includedFunctions);
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public SequentialPlannerRequestSettings addExcludedFunctions(String function) {
        HashSet<String> ex = new HashSet<String>(this.excludedFunctions);
        ex.add(function);
        return new SequentialPlannerRequestSettings(this.relevancyThreshold, this.maxRelevantFunctions, this.excludedSkills, ex, this.includedFunctions, this.maxTokens);
    }

    public SequentialPlannerRequestSettings addExcludedSkillName(String skillName) {
        HashSet<String> ex = new HashSet<String>(this.excludedSkills);
        ex.add(skillName);
        return new SequentialPlannerRequestSettings(this.relevancyThreshold, this.maxRelevantFunctions, ex, this.excludedFunctions, this.includedFunctions, this.maxTokens);
    }
}

