/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.connectors.ai.openai.util;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.AzureCliCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.semantickernel.connectors.ai.openai.util.AzureOpenAISettings;
import com.microsoft.semantickernel.connectors.ai.openai.util.OpenAIClientProvider;
import com.microsoft.semantickernel.exceptions.ConfigurationException;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AzureCredentialType {
    KEY{

        @Override
        @Nullable
        public TokenCredential getTokenCredential() {
            return null;
        }
    }
    ,
    MANAGED_IDENTITY{

        @Override
        @Nullable
        public TokenCredential getTokenCredential() {
            if (AzureCredentialType.classIsPresent("com.azure.identity.ManagedIdentityCredentialBuilder")) {
                return new ManagedIdentityCredentialBuilder().build();
            }
            return null;
        }
    }
    ,
    AZURE_CLI{

        @Override
        @Nullable
        public TokenCredential getTokenCredential() {
            if (AzureCredentialType.classIsPresent("com.azure.identity.AzureCliCredentialBuilder")) {
                return new AzureCliCredentialBuilder().build();
            }
            return null;
        }
    };

    private static final Logger LOGGER;

    @Nullable
    public abstract TokenCredential getTokenCredential();

    @Nullable
    public static TokenCredential getCredential() throws ConfigurationException {
        return AzureCredentialType.getCredential(null);
    }

    @Nullable
    public static TokenCredential getCredential(@Nullable List<File> propertyFileLocations) throws ConfigurationException {
        Map<String, String> settings = OpenAIClientProvider.getSettings(propertyFileLocations);
        return new AzureOpenAISettings(settings).getAzureOpenAiCredentialsType().getTokenCredential();
    }

    private static boolean classIsPresent(String className) {
        try {
            Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Requested Managed Identity or Azure CLI authentication, however the azure-identity library is not available on the classpath");
            return false;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(AzureCredentialType.class);
    }
}

