/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.CustomModifier;
import ch.epfl.lamp.compiler.msil.FieldAttributes;
import ch.epfl.lamp.compiler.msil.HasCustomModifiers;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.PECustomMod;

public class FieldInfo
extends MemberInfo
implements HasCustomModifiers {
    public final short Attributes;
    public final Type FieldType;
    public final CustomModifier[] cmods;
    protected final Object value;
    private boolean knownVolatile = false;
    private boolean cachedVolatile = false;
    protected static final FieldInfo[] EMPTY_ARRAY = new FieldInfo[0];

    @Override
    public final int MemberType() {
        return 4;
    }

    public final boolean IsStatic() {
        return (this.Attributes & 0x10) != 0;
    }

    public final boolean IsInitOnly() {
        return (this.Attributes & 0x20) != 0;
    }

    public final boolean IsLiteral() {
        return (this.Attributes & 0x40) != 0;
    }

    public final boolean IsPublic() {
        return (this.Attributes & 7) == 6;
    }

    public final boolean IsPrivate() {
        return (this.Attributes & 7) == 1;
    }

    public final boolean IsFamily() {
        return (this.Attributes & 7) == 4;
    }

    public final boolean IsAssembly() {
        return (this.Attributes & 7) == 3;
    }

    public final boolean IsFamilyOrAssembly() {
        return (this.Attributes & 7) == 5;
    }

    public final boolean IsFamilyAndAssembly() {
        return (this.Attributes & 7) == 2;
    }

    public final boolean IsSpecialName() {
        return (this.Attributes & 0x200) != 0;
    }

    public final boolean IsPinvokeImpl() {
        return (this.Attributes & 0x2000) != 0;
    }

    public final boolean IsNotSerialized() {
        return (this.Attributes & 0x80) != 0;
    }

    public final boolean IsVolatile() {
        if (this.knownVolatile) {
            return this.cachedVolatile;
        }
        this.knownVolatile = true;
        if (this.cmods == null) {
            this.cachedVolatile = false;
            return this.cachedVolatile;
        }
        for (int idx = 0; idx < this.cmods.length; ++idx) {
            if (this.cmods[idx].marker != CustomModifier.VolatileMarker()) continue;
            this.cachedVolatile = true;
            return this.cachedVolatile;
        }
        this.cachedVolatile = false;
        return this.cachedVolatile;
    }

    @Override
    public final Type[] GetOptionalCustomModifiers() {
        return CustomModifier.helperCustomMods(false, this.cmods);
    }

    @Override
    public final Type[] GetRequiredCustomModifiers() {
        return CustomModifier.helperCustomMods(true, this.cmods);
    }

    public String toString() {
        return FieldAttributes.toString(this.Attributes) + " " + this.FieldType + " " + this.DeclaringType.FullName + "::" + this.Name;
    }

    protected FieldInfo(String name, Type declType, int attrs, PECustomMod fieldTypeWithMods, Object value2) {
        super(name, declType);
        this.FieldType = fieldTypeWithMods.marked;
        this.cmods = fieldTypeWithMods.cmods;
        this.Attributes = (short)attrs;
        this.value = value2;
    }

    public Object getValue() {
        return this.value;
    }
}

