/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.emit.AssemblyBuilder;
import ch.epfl.lamp.compiler.msil.emit.MultipleFilesILPrinterVisitor;
import ch.epfl.lamp.compiler.msil.emit.SingleFileILPrinterVisitor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.ObjectRef;

public final class ILPrinterVisitor$ {
    public static final ILPrinterVisitor$ MODULE$;
    private final Type VOID;
    private final int TAB;
    private final String SPACES;
    private final int SPACES_LEN;
    private final String EMPTY;
    private Assembly currAssembly;
    private Map<Type, String> primitive;

    static {
        new ILPrinterVisitor$();
    }

    public final Type VOID() {
        return this.VOID;
    }

    public final int TAB() {
        return 4;
    }

    public final String SPACES() {
        return "                                ";
    }

    public final int SPACES_LEN() {
        return this.SPACES_LEN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasControlChars(String str) {
        NonLocalReturnControl nonLocalReturnControl;
        Object object = new Object();
        try {
            Predef$ predef$ = Predef$.MODULE$;
            int n = str.length();
            Serializable serializable2 = new Serializable(str, object){
                public static final long serialVersionUID = 0L;
                public final String str$1;
                public final Object nonLocalReturnKey1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    char ch = this.str$1.charAt(i);
                    switch (ch) {
                        default: {
                            if (!Character.isISOControl(ch)) break;
                            throw new NonLocalReturnControl$mcZ$sp(this.nonLocalReturnKey1$1, true);
                        }
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                    }
                }
                {
                    this.str$1 = str$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            };
            Range range2 = Range$.MODULE$.apply(0, n);
            if (!range2.validateRangeBoundaries((Function1<Object, Object>)((Object)serializable2))) return false;
            int n2 = range2.start();
            int n3 = range2.terminalElement();
            int n4 = range2.step();
            while (true) {
                if (n2 == n3) {
                    return false;
                }
                char ch1 = str.charAt(n2);
                switch (ch1) {
                    default: {
                        if (!Character.isISOControl(ch1)) break;
                        nonLocalReturnControl = new NonLocalReturnControl$mcZ$sp(object, true);
                        if (nonLocalReturnControl.key() == object) return nonLocalReturnControl.value$mcZ$sp();
                        throw nonLocalReturnControl;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                }
                n2 += n4;
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl2) {
            nonLocalReturnControl = nonLocalReturnControl2;
            if (nonLocalReturnControl2.key() != object) throw nonLocalReturnControl;
        }
        return nonLocalReturnControl.value$mcZ$sp();
    }

    public final String EMPTY() {
        return this.EMPTY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String msilString(String s2) {
        if (this.hasControlChars(s2)) {
            try {
                return new StringBuilder().append((Object)"bytearray (").append((Object)PEFile.bytes2hex(s2.getBytes("UTF-16LE"))).append((Object)")").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        StringBuffer str = new StringBuffer(s2);
        int i = 0;
        while (i < str.length()) {
            String ss = this.EMPTY();
            char c = str.charAt(i);
            switch (c) {
                default: {
                    if (!Character.isISOControl(c)) break;
                    ss = new StringBuilder().append((Object)"\\u").append((Object)PEFile.int2hex(Character.getNumericValue(c))).toString();
                    break;
                }
                case '\\': {
                    ss = "\\\\";
                    break;
                }
                case '\'': {
                    ss = "\\'";
                    break;
                }
                case '\"': {
                    ss = "\\\"";
                    break;
                }
                case '\r': {
                    ss = "\\r";
                    break;
                }
                case '\f': {
                    ss = "\\f";
                    break;
                }
                case '\n': {
                    ss = "\\n";
                    break;
                }
                case '\t': {
                    ss = "\\t";
                    break;
                }
                case '\b': {
                    ss = "\\b";
                }
            }
            String string2 = ss;
            String string3 = this.EMPTY();
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                str.replace(i, i + 1, ss);
                i = i + ss.length() - 1;
            }
            ++i;
        }
        return new StringBuilder().append((Object)"\"").append((Object)str.toString()).append((Object)"\"").toString();
    }

    public void printAssembly(AssemblyBuilder assemblyBuilder, String fileName) throws IOException {
        assemblyBuilder.apply(new SingleFileILPrinterVisitor(fileName));
    }

    public void printAssembly(AssemblyBuilder assemblyBuilder, String destPath, String sourceFilesPath) throws IOException {
        assemblyBuilder.apply(new MultipleFilesILPrinterVisitor(destPath, sourceFilesPath));
    }

    public Assembly currAssembly() {
        return this.currAssembly;
    }

    public void currAssembly_$eq(Assembly x$1) {
        this.currAssembly = x$1;
    }

    public final Map<Type, String> primitive() {
        return this.primitive;
    }

    public final void primitive_$eq(Map<Type, String> x$1) {
        this.primitive = x$1;
    }

    public void addPrimitive(String name, String sig) {
        ObjectRef<Type> type = new ObjectRef<Type>(Type.GetType(name));
        boolean bl = (Type)type.elem != null;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append((Object)"Cannot lookup primitive type ").append((Type)type.elem).toString()).toString());
        }
        this.primitive().put((Type)type.elem, sig);
    }

    private ILPrinterVisitor$() {
        MODULE$ = this;
        this.VOID = Type.GetType("System.Void");
        this.SPACES_LEN = "                                ".length();
        this.EMPTY = "";
        this.primitive = Map$.MODULE$.empty();
        this.addPrimitive("System.Object", "object");
        this.addPrimitive("System.String", "string");
        this.addPrimitive("System.Void", "void");
        this.addPrimitive("System.Boolean", "bool");
        this.addPrimitive("System.Char", "char");
        this.addPrimitive("System.SByte", "int8");
        this.addPrimitive("System.Byte", "unsigned int8");
        this.addPrimitive("System.Int16", "int16");
        this.addPrimitive("System.UInt16", "unsigned int16");
        this.addPrimitive("System.Int32", "int32");
        this.addPrimitive("System.UInt32", "unsigned int32");
        this.addPrimitive("System.Int64", "int64");
        this.addPrimitive("System.UInt64", "unsigned int64");
        this.addPrimitive("System.IntPtr", "native int");
        this.addPrimitive("System.UIntPtr", "unsigned native int");
        this.addPrimitive("System.Single", "float32");
        this.addPrimitive("System.Double", "float64");
        this.addPrimitive("System.TypedReference", "typedref");
    }
}

